#include "mbed.h"
#include "mbed_rpc.h"
#include "uLCD_4DGL.h"
#include <ctype.h>

/**
 *  This example program has been updated to use the RPC implementation in the new mbed libraries.
 *  This example shows the uses of the RPCDigitalOut wrapper class
 */
 
//Use the RPC enabled wrapped class  - see RpcClasses.h for more info
Serial pc(USBTX, USBRX);
PinName tx, rx, rst;
uLCD_4DGL uLCD(p28, p27, p29);
char text;
//string screen;
 
void clearLCD(Arguments *in, Reply *out);
RPCFunction rpcClear(&clearLCD, "clearLCD");

void printLCD(Arguments *in, Reply *out);
RPCFunction rpcPrint(&printLCD, "printLCD");
  
int main() {
 
    char buf[256], outbuf[256];
    while(1) {
        pc.gets(buf, 256);
        //Call the static call method on the RPC class
        RPC::call(buf, outbuf); 
        pc.printf("%s\n", outbuf);
    }
}

void clearLCD(Arguments *in, Reply *out)
{
    uLCD.cls();
    //out->putData("Successfully created uLCD object!");
}

void printLCD(Arguments *in, Reply *out)
{
        char * text = in->getArg<char *>();
        uLCD.puts(text);
        uLCD.puts("\n");
 }