/* draft mbed TextLCD 
 * (c) 2007/8, sford
 */
 
#ifndef WATTBOB_TEXTLCD_H
#define WATTBOB_TEXTLCD_H

#include "mbed.h"
#include "Stream.h"
#include "MCP23017.h"

#define     RS_BIT      7
#define     RW_BIT      6
#define     E_BIT       5
#define     BL_BIT      4   

/** Class to access 16*2 LCD display connected to an MCP23017 I/O extender chip
 *
 * Derived from the "stream" class to be able to use methods such as "printf"
 *
 * Example :
 * @code
 * .....
 * #include "MCP23017.h"
 * #include "WattBob_TextLCD.h"
 * .....
 * MCP23017            *par_port;
 * WattBob_TextLCD     *lcd;
 *      .....
 * int main()
 *      par_port = new MCP23017(p9, p10, 0x40);
 *      par_port->config(0x0F00, 0x0F00, 0x0F00);           // configure MCP23017 chip on WattBob       
 *      lcd = new WattBob_TextLCD(par_port);
 *
 *      par_port->write_bit(1,BL_BIT);   // turn LCD backlight ON
 *      lcd->cls(); lcd->locate(0,0);
 *      lcd->printf("%s", message);
 *      lcd->locate(1,0);lcd->printf("press 1 to cont"); 
 * @endcode
 */ 
class WattBob_TextLCD : public Stream {

public:
    /** Create TextLCD object connected to a MCP23017 device
     *
     * @param   port    pointer to MCP23017 object
     */ 
    WattBob_TextLCD(MCP23017 *port);
    
    /** Set cursor to a known point
     *
     * Virtual function for stream class
     *
     * @param   row   integer row number (0 or 1)
     * @param   col   integer column number (0 or 15)     
     */            
    virtual void locate(int row, int column);
    
    /** clear display
     *
     * Virtual function for stream class
     */     
    virtual void cls();

    /** reset the display
     *
     * Virtual function for stream class
     */             
    virtual void reset();
        
protected:

    virtual int _putc(int c);        
    virtual int _getc();
    virtual void newline();      
    
    void clock();
    void writeData(int data);
    void writeCommand(int command);
    void writeByte(int value);
    void writeNibble(int value);
    
    void _rs (int data);
    void _rw (int data);    
    void _e (int data);
    void _d (int data);
           
    int _rows;
    int _columns;
    int _row;
    int _column;   
    
private:
    MCP23017    *par_port; 
};

#endif
