#include "mbed.h"
#include "MCP23017.h"
#include "WattBob_TextLCD.h"

#define BACK_LIGHT_ON(INTERFACE) INTERFACE->write_bit(1,BL_BIT)
#define BACK_LIGHT_OFF(INTERFACE) INTERFACE->write_bit(0,BL_BIT)



AnalogIn sensor1(p15);
AnalogIn sensor2(p16);
AnalogOut valueLED1(p18);
DigitalOut valueLED2(p25);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut clk(p26);



MCP23017 *par_port; // pointer to 16-bit parallel I/O object
WattBob_TextLCD *lcd; // pointer to 2*16 chacater LCD object



int main() {

valueLED1=0;
valueLED2=0;
clk=0;
par_port = new MCP23017(p9, p10, 0x40); // initialise 16-bit I/O chip
lcd = new WattBob_TextLCD(par_port); // initialise 2*26 char display

par_port->write_bit(1,BL_BIT);




    while(1) {
        clk = !clk;
        wait(0.01);
    
        sensor1.read();
        sensor2.read();
        
        if(sensor1 > 0.5) {
                led1 = 1;
                valueLED1 = 1;
        }
        else if(sensor1 < 0.5){
               led1 = 0;
                valueLED1 = 0;
        }
        
        
        if(sensor2 > 0.5) {
                led2 = 1;
                valueLED2 = 1;
        }
        else{
                led2 = 0;
                valueLED2 = 0;
        }
        lcd->printf("%f\n",sensor2.read());
    }
}

