#include <mbed.h>
#include <Adafruit_ADS1015.h>
using namespace std;
/***************************************
LED 1 = Standy by mode
LED 2 = Reading Message
LED 3 = Wrighting Message
From The Keyboard
Cell Zero == 3 is if they are talking to us
Second character 0 == start
                 1 == stop
***************************************/
/**************************************
Initial Parameters
***************************************/
I2C i2c(p28, p27);           //pins 27/28 for I2C interface
Adafruit_ADS1015 ads(&i2c);
Serial pc(USBTX, USBRX); // tx, rx
DigitalOut led(LED1);    // LED 1 for state 1
DigitalOut led2(LED2);   // LED 2 for state 2
DigitalOut led3(LED3);   // LED 3 for state 3
CAN can(p30, p29);       //p30(rx) and p29(tx)
LocalFileSystem local("local"); //Output file location
CANMessage msg;
char state;
FILE *fp = fopen("/local/out.txt", "w"); //File initialization
int i = 0;
/*************************************
Function Status keeps checking the bus waiting for the KeyBoard Subgroup
To tell us to start reading from the blackbox.
*************************************/
void get_state()
{
    can.read(msg);
    char Cell_One = msg.data[0];
    char Cell_Two = msg.data[1];
    if (Cell_One == '3' && Cell_Two == '0')    {
        pc.printf("Reading \r \n");
        state = 2;
    } else if (Cell_One == '3' && Cell_Two == '1') {
        pc.printf("Writing \r \n");
        state = 3;
        i = 0;
    } else
        pc.printf("Waiting \r \n");
    state = state;

}
int main()
{
    state = 1;
    pc.baud(9600);
    pc.printf("\r \n");
    pc.printf("\r \n");
    pc.printf("Hello! \r \n");
    pc.printf("Note: ADC Range +/- 6.144 (1 bit = 3mV/ADS1015, 0.1875mV/ ADS1115)\r \n");
    pc.printf("Waitng.... \r \n");
    uint16_t adc0; // channel coming from the black box
    float conversion_factor = .003;
    can.attach(&get_state , CAN::RxIrq);
    while (1) {

        if (state == 2) {
            adc0 = ads.readADC_SingleEnded(0); // read channel 0
            pc.printf("AIN0: %f\r\n", adc0*conversion_factor);   // print channel 0
            fprintf(fp, "%f\r\n", adc0*conversion_factor);
            led = 0;
            led2 = 1;
            led3 = 0;
            wait(0.01); //100 hz
        } else if (state == 3) {
            fclose(fp);
            led = 0;
            led2 = 0;
            led3 = 1;
            if(i == 0) {
                pc.printf("File Complete \r \n");
                i++;
            }
            state = 1;
        } else {
            led = 1;
            led2 = 0;
            led3 = 0;
        }
    }
}