/* mbed Microcontroller Library
 * Copyright (c) 2017 u-blox
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
 
/* This example program for the u-blox C030 board.
 * The UbloxATCellularInterface or OnboardCellularInterface uses it
 * to make a simple HTTP connection to a STC IOT server.
 * Progress may be monitored with a serial terminal running at 9600 baud or at https://ksu.aep1.iot.stcs.com.sa 
 * The LED on the C030 board will turn green when this program is
 * operating correctly, pulse blue when a sockets operation is completed
 * and turn red if there is a failure.
 
 * Modified by: Muhammad Faheem Khan (Digital Solutions, STCS) 
 */
 
#include "mbed.h"
#include "UbloxATCellularInterface.h"
#include "UbloxATCellularInterfaceN2xx.h"
#include "LM75B.h"   // Temperature Sensor Library. Import more libraries from https://os.mbed.com/components/mbed-Application-Shield/
#include "C12832.h"  // LCD Library. Import more libraries from https://os.mbed.com/components/mbed-Application-Shield/
#include "MMA7660.h" //HERE

// Sensor Pin and Object Activation
C12832 lcd(D11, D13, D12, D7, D10);
//LM75B sensor(D14,D15);
MMA7660 MMA(D14,D15); //HERE
PwmOut spkr(D6);

#define INTERFACE_CLASS  UbloxATCellularInterface  //This interface is used to initiate modem commands for sending data to sever

// The credentials of the SIM in the board.  If PIN checking is enabled
// for your SIM card you must set this to the required PIN.
#define PIN "0000"
#define APN         "jtm2m"   //APN remains the same for all the kits
#define USERNAME    NULL
#define PASSWORD    NULL
#define TCP_SERVER "integration.campus.stcs.io"   //STC IoT parsing server address

// LEDs
//DigitalOut connectionLed(LED1);//operation confirmed                     HERE
DigitalOut servoProxyLed(LED2);//score outcome, proxy for servo          HERE
DigitalOut ledRed(LED1, 1);
DigitalOut ledGreen(LED2, 1);
DigitalOut ledBlue(LED3, 1);
DigitalIn fire(D4);


// The user button
volatile bool buttonPressed = false;


static void good() {
    ledGreen = 0;
    ledBlue = 1;
    ledRed = 1;
}

static void bad() {
    ledRed = 0;
    ledGreen = 1;
    ledBlue = 1;
}

static void event() {
    ledBlue = 0;
    ledRed = 1;
    ledGreen = 1;
}

static void pulseEvent() {
    event();
    wait_ms(500);
    good();
}

static void ledOff() {
    ledBlue = 1;
    ledRed = 1;
    ledGreen = 1;
}
static void cbButton()
{
    buttonPressed = true;
    pulseEvent();
}


    

float         stable= 0 ;
const   int n = 10;                         //number of readings to be averaged, change globally here           HERE
float       score = 0;                      //reserved for later                                                HERE
int         angle = 0;                      //reserved for later                                                HERE
float       pulseXT =0, pulseYT = 0;        //Total holders for summation from axis arrays                      HERE

float       pulseXa, pulseYa;               //averaged values for each axis over n                              HERE
float       pulseX[n], pulseY[n];           //arrays to hold n readings for each axis                           HERE
int         i, j;                           //indexing variables                                            HERE
char xval[100]; // this buffer will be used to store sensor values
char yval[100]; // this buffer will be used to store sensor values
char zval[100]; // this buffer will be used to store sensor values
char buf[1024];  // this buffer is used to send POST data to platform
 char deviceID[20] = "357520074039765";
//void fun(char *str,float x)
//{
    //snprintf(str,sizeof str,"X-axis=%.2f", x);
    //snprintf(buf, sizeof buf, "%s%s%s%s%s%s", "POST /ksu/?deviceID=",deviceID,"&",str,"&unit=T", " HTTP/1.0\r\n\r\n");

   // printf(buf);
    
//}
int main()
{
    INTERFACE_CLASS *interface = new INTERFACE_CLASS();
    // If you need to debug the cellular interface, comment out the
    // instantiation above and uncomment the one below.
    // For the N2xx interface, change xxx to MBED_CONF_UBLOX_CELL_BAUD_RATE,
    // while for the non-N2xx interface change it to MBED_CONF_UBLOX_CELL_N2XX_BAUD_RATE.
//    INTERFACE_CLASS *interface = new INTERFACE_CLASS(MDMTXD, MDMRXD,
//                                                     xxx,
//                                                     true);
#ifndef TARGET_UBLOX_C030_N211
    TCPSocket sockTcp;
    TCPSocket sockTcp2;
    TCPSocket sockTcp3;

#endif
   
    SocketAddress tcpServer;
    //char deviceID[20] = "357520074039765";
   // char buf[1024];  // this buffer is used to send POST data to platform
    char buf2[1024];
    char buf3[1024];
    char temp[50]; // this buffer will be used to store sensor values
    int x;

#ifdef TARGET_UBLOX_C027
    // No user button on C027
    InterruptIn userButton(NC);
#else
    InterruptIn userButton(SW0);
#endif
    
    // Attach a function to the user button
    userButton.rise(&cbButton);
    
    good();
    printf("Starting up, please wait up to 180 seconds for network registration to complete...\n");
    interface->set_credentials(APN, USERNAME, PASSWORD);
    for (x = 0; interface->connect(PIN) != 0; x++) {
        if (x > 0) {
            bad();
            printf("Retrying (have you checked that an antenna is plugged in and your APN is correct?)...\n");
        }
    }
    pulseEvent();
    
    printf("Getting the IP address of \"integration.campus.stcs.io\"...\n");
    if (interface->gethostbyname(TCP_SERVER, &tcpServer) == 0) {
        pulseEvent();

        tcpServer.set_port(1880);
        //tcpServer2.set_port(1881);
        printf("\"integration.campus.stcs.io\" address: %s on port %d.\n", tcpServer.get_ip_address(), tcpServer.get_port());

        printf("Performing socket operations in a loop (until the user button is pressed on C030)...\n");
        while (!buttonPressed) {
            
#ifndef TARGET_UBLOX_C030_N211
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("Connecting");
        
           // TCP Sockets
            printf("=== TCP ===\n");
            printf("Opening a TCP socket...\n");
            if (sockTcp.open(interface) == 0) {
                pulseEvent();
                printf("TCP socket open.\n");
                sockTcp.set_timeout(10000);
                printf("Connecting socket to %s on port %d...\n", tcpServer.get_ip_address(), tcpServer.get_port());
                if (sockTcp.connect(tcpServer) == 0) {
                    pulseEvent();
                      lcd.cls();
                      lcd.locate(0,3);
                      lcd.printf("Connected");
                      wait(2.0);
                    printf("Connected, sending HTTP GET request to %s over socket...\n", TCP_SERVER);
                      lcd.cls();
                      lcd.locate(0,3);
                    wait(1.0);
                    printf("=== TCP ===\n");
            printf("Opening a TCP socket 2...\n");
            if (sockTcp2.open(interface) == 0) {
                pulseEvent();
                printf("TCP socket open.\n");
                sockTcp2.set_timeout(10000);
                printf("Connecting socket to %s on port %d...\n", tcpServer.get_ip_address(), tcpServer.get_port());// kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk
                if (sockTcp2.connect(tcpServer) == 0) {
                    pulseEvent();
                      lcd.cls();
                      lcd.locate(0,3);
                      lcd.printf("Connected");
                      wait(2.0);
                    printf("Connected, sending HTTP GET request to %s over socket...\n", TCP_SERVER);
                      lcd.cls();
                      lcd.locate(0,3);
                      wait(1.0);
                       printf("=== TCP ===\n");
            printf("Opening a TCP socket3...\n");
            if (sockTcp3.open(interface) == 0) {
                pulseEvent();
                printf("TCP socket open.\n");
                sockTcp3.set_timeout(10000);
                printf("Connecting socket to %s on port %d...\n", tcpServer.get_ip_address(), tcpServer.get_port());
                if (sockTcp3.connect(tcpServer) == 0) {
                    pulseEvent();
                      lcd.cls();
                      lcd.locate(0,3);
                      lcd.printf("Connected");
                      wait(2.0);
                    printf("Connected, sending HTTP GET request to %s over socket...\n", TCP_SERVER);
                      lcd.cls();
                      lcd.locate(0,3);
                    
                    // Sensor Data is stored in temp variable before pushing to platform
                    
                   // while(1) {    //HERE

       // for (i = 0; i < n; i = i + 1) {     //read n values into each axis array
        //    pulseX[i] = MMA.x();
         //   pulseY[i] = MMA.y();
        //}
        //pulseXT = 0;                        //reset Totala
       // pulseYT = 0;                        //reset Totala
       // for (j = 0; j < n; j = j + 1) {     //summation of the contents of each array into axis Totals
        //    pulseXT = pulseXT+pulseX[j];
        //    pulseYT = pulseYT+pulseY[j];
        //}
        //pulseXa = pulseXT/n;                //axis average over n
        pulseXa = MMA.x();
       // pulseYa = pulseYT/n;                //axis average over n
          pulseYa = MMA.y();
        //if (MMA.testConnection())
          //  connectionLed = 1;

        if (pulseXa > (-0.2) && pulseXa < (0.2) && pulseYa > (-0.2) && pulseYa < (0.2)) {//average result within stability range; x, y
            lcd.cls();//clear LCD for next reading round
            lcd.locate(3,3);//first LCD column label
            lcd.printf("x-axis | ");//label column
            lcd.locate(3,12);//xdata location
            lcd.printf("%.2f\n",pulseXa);//print x to LCD
            lcd.locate(40,3);//second LCD column label
            lcd.printf("y-axis | ");//label column
            lcd.locate(40,12);//ydata location
            lcd.printf("%.2f\n",pulseYa);//print y to LCD
            lcd.locate(77,3);//initial LCD location
            lcd.printf("z-axis");//label column
            lcd.locate(77,12);//zdata location
            lcd.printf("%.2f\n",MMA.z());//print z to LCD
            lcd.locate(3,21);//flag location
            lcd.printf("STABLE");//flag
            stable = 1 ;
            wait_ms(2000); 
            
        }

        else {////average result not within stability range; x, y
            lcd.cls();//clear LCD for next reading round
            lcd.locate(3,3);//first LCD column label
            lcd.printf("x-axis | ");//label column
            lcd.locate(3,12);//xdata location
            lcd.printf("%.2f\n",pulseXa);//print x to LCD
            lcd.locate(40,3);//second LCD column label
            lcd.printf("y-axis | ");//label column
            lcd.locate(40,12);//ydata location
            lcd.printf("%.2f\n",pulseYa);//print y to LCD
            lcd.locate(77,3);//initial LCD location
            lcd.printf("z-axis");//label column
            lcd.locate(77,12);//zdata location
            lcd.printf("%.2f\n",MMA.z());//print z to LCD
            lcd.locate(3,21);//flag location
            lcd.printf("UNSTABLE");//flag
            stable = 0 ;
            wait_ms(2000); 
            
            int snd = 0;
    while (snd != 1) {
        snd++;
        for (float i=2000.0; i<10000.0; i+=100) {
            spkr.period(1.0/i);
            spkr=0.1;
            wait(0.5);
        }
        spkr=0.0;        
    }
    

        }
    //}
//    vall val ;

                   // reading_value(xval,pulseXa);
                  // val.x = pulseXa;
                   //val.y = pulseYa;
                   // snprintf(temp,sizeof temp,"Temperature=%.1f", sensor.temp());  //Sensor Key "Temperature" and Value is Sensor Data
                   //fun(xval,pulseXa);
/*float values []= {pulseXa , pulseYa};
char* v [] = {xval,yval};
int ptr = 0;*/
//for( i = 0; i < 2; i++)
//{
   // ptr += snprintf(xval + ptr, sizeof(xval) - ptr, "X-axis=%.2f", values[i]);  
        
 
//}
               snprintf(xval,sizeof xval,"X-axis=%.2f", pulseXa);  //Sensor Key "Temperature" and Value is Sensor Data
               snprintf(yval,sizeof yval,"Y-axis=%.2f", pulseYa);  //Sensor Key "Temperature" and Value is Sensor Data
               snprintf(zval,sizeof zval,"Stability Status=%.2f", stable );  //Sensor Key "Temperature" and Value is Sensor Data

                   
                    //lcd.printf("%s", temp); // Display Temperature value on LCD
                    
                    /* create a buf with HTTP POST call to platform, user must define below structure
                    
                    1. deviceID --- This is the IMEI of the device, available on back side of the board
                    2. temp -- This is a temporary variable to hold sensor Key and Value. For example, "Temperature"="24.5". Here Key is Temperature and Value is 24.5
                    3. unit -- This is sensor data unit. For example, C for Temperature
                    
                    Repeat the steps for sending more than 1 value to platform. Alternatively, user can define this process as a function for sending multiple values.
                    
                    */              
                    
                    //snprintf(buf, sizeof buf, "%s%s%s%s%s%s", "POST /ksu/?deviceID=",deviceID,"&",temp,"&unit=T"," HTTP/1.0\r\n\r\n");
                    
                    
                   snprintf(buf, sizeof buf, "%s%s%s%s%s%s", "POST /ksu/?deviceID=",deviceID,"&",xval,"&unit=T", " HTTP/1.0\r\n\r\n");
                   snprintf(buf2, sizeof buf2, "%s%s%s%s%s%s", "POST /ksu/?deviceID=",deviceID,"&",yval,"&unit=C"," HTTP/1.0\r\n\r\n");
                   snprintf(buf3, sizeof buf3, "%s%s%s%s%s%s", "POST /ksu/?deviceID=",deviceID,"&",zval,"&unit=T"," HTTP/1.0\r\n\r\n");

                    printf("Output string is %s",buf);
                                  
                    // Note: since this is a short string we can send it in one go as it will
                    // fit within the default buffer sizes.  Normally you should call sock.send()
                    // in a loop until your entire buffer has been sent.
                    if (sockTcp.send((void *) buf, strlen(buf)) == (int) strlen(buf)) {
                        pulseEvent();
                        printf("Socket send completed, waiting for response...\n");
                        x = sockTcp.recv(buf, sizeof (buf));
                        if (x > 0) {
                            pulseEvent();
                            printf("Received %d byte response from server on TCP socket:\n"
                                   "----------------------------------------------------\n%.*s"
                                   "----------------------------------------------------\n",
                                    x, x, buf);
                        }
                    }
                    if (sockTcp2.send((void *) buf2, strlen(buf2)) == (int) strlen(buf2)) {
                        pulseEvent();
                        printf("Socket send completed, waiting for response...\n");
                        x = sockTcp2.recv(buf2, sizeof (buf2));
                        if (x > 0) {
                            pulseEvent();
                            printf("Received %d byte response from server on TCP socket:\n"
                                   "----------------------------------------------------\n%.*s"
                                   "----------------------------------------------------\n",
                                    x, x, buf2);
                        }
                    }
                     if (sockTcp3.send((void *) buf3, strlen(buf3)) == (int) strlen(buf3)) {
                        pulseEvent();
                        printf("Socket send completed, waiting for response...\n");
                        x = sockTcp3.recv(buf3, sizeof (buf3));
                        if (x > 0) {
                            pulseEvent();
                            printf("Received %d byte response from server on TCP socket:\n"
                                   "----------------------------------------------------\n%.*s"
                                   "----------------------------------------------------\n",
                                    x, x, buf3);
                        }
                    }
                
                  
                    }}}
                
                      lcd.cls();
                      lcd.locate(0,3);
                      lcd.printf("Resend after 10s");
                      wait(1.0);
                printf("Closing socket...\n");
                sockTcp.close();
                sockTcp2.close();
                sockTcp3.close();
                pulseEvent();
                printf("Socket closed.\n");
            }}}
#endif
            wait_ms(10000);  //Loop delay in milliseconds. Keep it more than 10 seconds to save data usage on cellular
#ifndef TARGET_UBLOX_C027
            printf("[Checking if user button has been pressed]\n");
#endif
        }
        
        pulseEvent();
        printf("User button was pressed, stopping...\n");
        interface->disconnect();
        ledOff();
        printf("Stopped.\n");
    } 
    else {
        bad();
        printf("Unable to get IP address of \"integraton.campus.stcs.io\".\n");
    }


}
