#include "mbed.h"
#include "CMPS03.h"
#include "GPS.h"
#include "C12832_lcd.h"
#include "MSCFileSystem.h"
#define FSNAME "msc"
C12832_LCD lcd;// Local name for the LCD
MSCFileSystem msc(FSNAME);
Serial pc(USBTX, USBRX);
GPS gps(p9, p10);
CMPS03 compass(p28, p27, CMPS03_DEFAULT_I2C_ADDRESS);

int lock = 0;
int main() {
    DIR *d;
    struct dirent *p;
    d = opendir("/" FSNAME);
    
    lcd.cls();
    lcd.locate(1,0); 
    lcd.printf("GPS Tester");
    lcd.locate(1,11);
    lcd.printf("Connect GPS to pins 9 & 10");  
    gps.Init();
    gps.parseData();
    FILE *fp = fopen( "/" FSNAME "/Tracker_data.txt", "a");
    fprintf(fp,"---A New reset---");
    fclose(fp); 
    while(1) {
        if(gps.parseData()) {
            FILE *fp = fopen( "/" FSNAME "/Tracker_data.txt", "a");
            lcd.cls();
            lcd.locate(1,0);
            lcd.printf("%f, %f, %d\n", gps.latitude, gps.longitude, gps.hours);
            lcd.locate(1,11);
            lcd.printf("%02d:%02d:%02.0f Bearing is: %f\n", 
                gps.hours, gps.minutes, gps.seconds, 
                (compass.readBearing() / 10.0));
            lcd.locate(1,22);
            lcd.printf("Satellites: %02d\n", gps.satellites);
            lcd.invert(0);
            fprintf(fp, "%f %f %f %02d:%02d:%02.0f__\n", gps.latitude, gps.longitude,(compass.readBearing() / 10.0),gps.hours, gps.minutes, gps.seconds);
            fclose(fp); 
        } else {
            lcd.cls();//clear LCD for next reading round
            lcd.locate(1,0);
            lcd.printf("No satellite lock\n");
            lcd.locate(1,11);
            lcd.printf("%02d:%02d:%02.0f %02d/%02d/%02d\n", 
                gps.hours, gps.minutes, gps.seconds, 
                gps.day, gps.month, gps.year);
            lcd.locate(1,22);
            lcd.printf("Satellites: %02d\n",gps.satellites);
            lcd.invert(0);
        }
    }
}