#include "mbed.h"
#include "arm_math.h"
#include "arm_common_tables.h"
#include "arm_const_structs.h"
#include "math_helper.h"
#include "IIR.h"
#include "FIR.h"
#include "logo.h"
#include "SeeedGrayOLED.h"

Serial pc(SERIAL_TX, SERIAL_RX);            //串口
DigitalOut myled(LED1);                     //LED
SeeedGrayOLED myOLED;                       //OLED屏幕
InterruptIn button(USER_BUTTON);            //用户按键
/*******************************滤波器系数及函数声明部分*****************************************/
#define numStages 2                                                 /*2阶IIR滤波的个数*/
#define TEST_LENGTH_SAMPLES 2048                                    /*采样点数*/
#define BLOCK_SIZE           32
#define NUM_TAPS             91

uint32_t blockSize = BLOCK_SIZE;
uint32_t numBlocks = TEST_LENGTH_SAMPLES/BLOCK_SIZE;

static void arm_iir_f32_lp(float32_t scale_1,float32_t scale_2);                                   /*IIR低通滤波器函数*/
static void arm_fir_f32_lp(void);                                   /*FIR低通滤波器函数*/

static float32_t testInput[TEST_LENGTH_SAMPLES];                    /*输入信号数组*/
static float32_t testOutput[TEST_LENGTH_SAMPLES];                   /*输出信号数组*/

static float32_t IIRStateF32[4*numStages];                          /*状态缓存，大小numTaps + blockSizes - 1*/
static float32_t firStateF32[BLOCK_SIZE + NUM_TAPS - 1];

/*
*********************************************************************
* 函数名：arm_iir_f32_lp
* 功能说明：调用函数arm_iir_f32_lp实现低通滤波器
* 形参：无
* 返回值：无
*********************************************************************
*/
static void arm_iir_f32_lp(float32_t scale_1,float32_t scale_2)
{
    uint32_t i;
    arm_biquad_casd_df1_inst_f32 S;
    float32_t ScaleValue;

    /*初始化*/
    arm_biquad_cascade_df1_init_f32(&S, numStages, (float32_t *)&IIRCoeffs32LP[0],(float32_t *)&IIRStateF32[0]);
    /*IIR滤波*/
    arm_biquad_cascade_df1_f32(&S,testInput, testOutput,TEST_LENGTH_SAMPLES);
    /*放缩系数*/
    //ScaleValue = 0.052219514664161221f * 0.04279801741658381f;
    ScaleValue = scale_1 * scale_2;
    /*打印滤波后结果*/
    for(i = 0; i<TEST_LENGTH_SAMPLES; i++) {
        pc.printf("%f\r\n",testOutput[i]*ScaleValue);
    }
}

static void arm_fir_f32_lp(void)
{
    uint32_t i;
    arm_fir_instance_f32 S;
    float32_t  *inputF32, *outputF32;


    inputF32 = &testInput[0];
    outputF32 = &testOutput[0];

    arm_fir_init_f32(&S, NUM_TAPS, (float32_t *)&firCoeffs32LP[0], &firStateF32[0], blockSize);

    for(i=0; i < numBlocks; i++) {
        arm_fir_f32(&S, inputF32 + (i * blockSize), outputF32 + (i * blockSize), blockSize);
    }

    for(i=0; i < TEST_LENGTH_SAMPLES; i++){
    printf("%f\r\n", testOutput[i]);
    }
}

/*
*********************************************************************
* 函数名：DSP_Sine_Synthesis
* 功能说明：调用函数arm_sin_f32,生成采样频率1000Hz的50Hz正弦波和200Hz正弦波
* 形参：f1-信号1频率,f2-信号2频率
* 返回值：无
*********************************************************************
*/
static void DSP_Sine_Synthesis(int f1,int f2,int f3,int a1,int a2,int a3,int random,int seed)
{
    uint16_t i;
    float32_t testInput_f32_random_siganl[TEST_LENGTH_SAMPLES];
    if(random == 0) {
        for(i = 0; i < TEST_LENGTH_SAMPLES; i++) {
            testInput[i] = a1*arm_sin_f32(2*3.1415926f*f1*i/1000) + a2*arm_sin_f32(2*3.1415926f*f2*i/1000)+ a3*arm_sin_f32(2*3.1415926f*f3*i/1000);
        }
    } else if(random == 1) {
        for(i = 0; i < TEST_LENGTH_SAMPLES; i++) {
            seed = (156*seed +1024)%65535;
            testInput_f32_random_siganl[i] = (seed/65535.0f)*2.0f-1.0f;
            testInput[i] = a1*arm_sin_f32(2*3.1415926f*f1*i/1000) + a2*arm_sin_f32(2*3.1415926f*f2*i/1000)+ a3*arm_sin_f32(2*3.1415926f*f3*i/1000);
            testInput[i] += testInput_f32_random_siganl[i];
        }
    }

    for(i = 0; i < TEST_LENGTH_SAMPLES; i++) {
        pc.printf("%f\r\n",testInput[i]);
    }
}

int main()
{
    int f1,f2,f3,a1,a2,a3,random,seed;
    char str1[10];
        myOLED.init(SH1107G);
    logo:myOLED.clearDisplay();
    while(1) {
        myOLED.drawzifu(1,0,str_shu2,16*16/8);      //数
        myOLED.drawzifu(2,0,str_zi,16*16/8);        //字
        myOLED.drawzifu(3,0,str_lv,16*16/8);        //滤
        myOLED.drawzifu(4,0,str_bo,16*16/8);        //波
        myOLED.drawzifu(5,0,str_qi,16*16/8);        //器
        myOLED.drawzifu(6,0,str_shi1,16*16/8);      //实
        myOLED.drawzifu(7,0,str_yan1,16*16/8);      //验

        myOLED.drawzifu(2,2,str_deng,16*16/8);      //等
        myOLED.drawzifu(3,2,str_dai,16*16/8);       //待
        myOLED.drawzifu(4,2,str_she,16*16/8);       //设
        myOLED.drawzifu(5,2,str_zhi,16*16/8);       //置
        myOLED.drawzifu(2,3,str_xin,16*16/8);       //信
        myOLED.drawzifu(3,3,str_hao,16*16/8);       //号
        myOLED.drawzifu(4,3,str_can,16*16/8);       //参
        myOLED.drawzifu(5,3,str_shu2,16*16/8);      //数
        pc.scanf("%s",str1);
        if(strcmp(str1,"set_para") == 0) {
            pc.scanf("%d %d %d %d %d %d %d %d",&f1,&f2,&f3,&a1,&a2,&a3,&random,&seed);              //读取信号参数      
            myOLED.drawzifu(2,2,str_xin,16*16/8);           //信
            myOLED.drawzifu(3,2,str_hao,16*16/8);           //号
            myOLED.drawzifu(4,2,str_can,16*16/8);           //参
            myOLED.drawzifu(5,2,str_shu2,16*16/8);          //数
            myOLED.drawzifu(2,3,str_she,16*16/8);           //设
            myOLED.drawzifu(3,3,str_zhi,16*16/8);           //置
            myOLED.drawzifu(4,3,str_wan,16*16/8);           //完
            myOLED.drawzifu(5,3,str_cheng,16*16/8);         //成
            while(1) {
                pc.scanf("%s",str1);
                if(strcmp(str1,"send_data") == 0) {
                    myOLED.drawzifu(2,2,str_zheng,16*16/8);     //正
                    myOLED.drawzifu(3,2,str_zai,16*16/8);       //在
                    myOLED.drawzifu(4,2,str_shang,16*16/8);     //上
                    myOLED.drawzifu(5,2,str_chuan,16*16/8);     //传
                    myOLED.drawzifu(2,3,str_yuan,16*16/8);      //原
                    myOLED.drawzifu(3,3,str_shi2,16*16/8);      //始
                    myOLED.drawzifu(4,3,str_xin,16*16/8);       //信
                    myOLED.drawzifu(5,3,str_hao,16*16/8);       //号
                    DSP_Sine_Synthesis(f1,f2,f3,a1,a2,a3,random,seed);
                    myOLED.drawzifu(2,2,str_xin,16*16/8);       //信
                    myOLED.drawzifu(3,2,str_hao,16*16/8);       //号
                    myOLED.drawzifu(4,2,str_shu2,16*16/8);      //数
                    myOLED.drawzifu(5,2,str_ju,16*16/8);        //据
                    myOLED.drawzifu(2,3,str_shang,16*16/8);     //上
                    myOLED.drawzifu(3,3,str_chuan,16*16/8);     //传
                    myOLED.drawzifu(4,3,str_wan,16*16/8);       //完
                    myOLED.drawzifu(5,3,str_cheng,16*16/8);     //成
                    while(1)
                    {
                        pc.scanf("%s",str1);
                        if(strcmp(str1,"iir_data") == 0)
                        {
                            myOLED.clearDisplay();
                            myOLED.drawzifu(1,1,str_lv,16*16/8);      //滤
                            myOLED.drawzifu(2,1,str_bo,16*16/8);      //波
                            myOLED.drawzifu(3,1,str_qi,16*16/8);      //器
                            myOLED.drawzifu(4,1,str_lei,16*16/8);     //类
                            myOLED.drawzifu(5,1,str_xing,16*16/8);    //型
                            
                            myOLED.drawzifu(2,2,str_i,16*16/8);       //I
                            myOLED.drawzifu(3,2,str_i,16*16/8);       //I
                            myOLED.drawzifu(4,2,str_r,16*16/8);       //R
                            
                            myOLED.drawzifu(2,4,str_zheng,16*16/8);   //正
                            myOLED.drawzifu(3,4,str_zai,16*16/8);     //在
                            myOLED.drawzifu(4,4,str_shang,16*16/8);   //上
                            myOLED.drawzifu(5,4,str_chuan,16*16/8);   //传
                            myOLED.drawzifu(2,5,str_lv,16*16/8);      //滤
                            myOLED.drawzifu(3,5,str_bo,16*16/8);      //波
                            myOLED.drawzifu(4,5,str_shu2,16*16/8);    //数
                            myOLED.drawzifu(5,5,str_ju,16*16/8);      //据
                            arm_iir_f32_lp(0.052219514664161221f,0.04279801741658381f);
                            
                            myOLED.drawzifu(2,4,str_lv,16*16/8);      //滤
                            myOLED.drawzifu(3,4,str_bo,16*16/8);      //波
                            myOLED.drawzifu(4,4,str_shu2,16*16/8);    //数
                            myOLED.drawzifu(5,4,str_ju,16*16/8);      //据
                            myOLED.drawzifu(2,5,str_shang,16*16/8);   //上
                            myOLED.drawzifu(3,5,str_chuan,16*16/8);   //传
                            myOLED.drawzifu(4,5,str_wan,16*16/8);     //完
                            myOLED.drawzifu(5,5,str_cheng,16*16/8);   //成
                            wait(5);
                            goto logo;
                        }
                        else if(strcmp(str1,"fir_data") == 0)
                        {
                            myOLED.clearDisplay();
                            myOLED.drawzifu(1,1,str_lv,16*16/8);      //滤
                            myOLED.drawzifu(2,1,str_bo,16*16/8);      //波
                            myOLED.drawzifu(3,1,str_qi,16*16/8);      //器
                            myOLED.drawzifu(4,1,str_lei,16*16/8);     //类
                            myOLED.drawzifu(5,1,str_xing,16*16/8);    //型
                            
                            myOLED.drawzifu(2,2,str3_2,16*16/8);      //F
                            myOLED.drawzifu(3,2,str_i,16*16/8);       //I
                            myOLED.drawzifu(4,2,str_r,16*16/8);       //R
                            
                            myOLED.drawzifu(2,4,str_zheng,16*16/8);   //正
                            myOLED.drawzifu(3,4,str_zai,16*16/8);     //在
                            myOLED.drawzifu(4,4,str_shang,16*16/8);   //上
                            myOLED.drawzifu(5,4,str_chuan,16*16/8);   //传
                            myOLED.drawzifu(2,5,str_lv,16*16/8);      //滤
                            myOLED.drawzifu(3,5,str_bo,16*16/8);      //波
                            myOLED.drawzifu(4,5,str_shu2,16*16/8);    //数
                            myOLED.drawzifu(5,5,str_ju,16*16/8);      //据
                            arm_fir_f32_lp();
                            myOLED.drawzifu(2,4,str_lv,16*16/8);      //滤
                            myOLED.drawzifu(3,4,str_bo,16*16/8);      //波
                            myOLED.drawzifu(4,4,str_shu2,16*16/8);    //数
                            myOLED.drawzifu(5,4,str_ju,16*16/8);      //据
                            myOLED.drawzifu(2,5,str_shang,16*16/8);   //上
                            myOLED.drawzifu(3,5,str_chuan,16*16/8);   //传
                            myOLED.drawzifu(4,5,str_wan,16*16/8);     //完
                            myOLED.drawzifu(5,5,str_cheng,16*16/8);   //成
                            wait(5);
                            goto logo;
                        }
                    }
                    
                }
            }
        }
    }
}