#include "mbed.h"
#include "arm_math.h"
#include "arm_common_tables.h"
#include "arm_const_structs.h"
#include "math_helper.h"
#include "SeeedGrayOLED.h"
#include "logo.h"

Serial pc(SERIAL_TX, SERIAL_RX);            //串口
DigitalOut myled(LED1);                     //LED
SeeedGrayOLED myOLED;                       //OLED屏幕
InterruptIn button(USER_BUTTON);            //用户按键

#define TEST_LENGTH_SAMPLES 2048

static void arm_cfft_f32_app(uint32_t ifftFlag);
static void arm_rfft_fast_f32_app(uint32_t ifftFlag);

static float32_t testOutput[TEST_LENGTH_SAMPLES];
static float32_t testInput[TEST_LENGTH_SAMPLES];
static float32_t testInput_cfft[TEST_LENGTH_SAMPLES];
static float32_t testInput_rfft[TEST_LENGTH_SAMPLES];
/*
********************************************************************************
* 函 数 名: arm_cfft_f32_app
* 功能说明: 调用函数arm_cfft_f32_app计算幅频
* 形   参:  无
* 返 回 值: 无
********************************************************************************
*/
static void arm_cfft_f32_app(uint32_t ifftFlag)
{
    uint16_t i;
    uint32_t fftSize = 1024;
    uint32_t doBitReverse = 1;
    if(ifftFlag == 0) {
        /* 按照实部,虚部,实部,虚部.....的顺序存储数据 */
        for(i = 0; i<TEST_LENGTH_SAMPLES/2; i++) {
            testInput_cfft[i*2+1] = 0;
            /* 50Hz正弦波,采样率1kHz */
            testInput_cfft[i*2] = testInput[i];
        }
        /* CFFT变换 */
        arm_cfft_f32(&arm_cfft_sR_f32_len1024,testInput_cfft,ifftFlag,doBitReverse);
        /* 求解模值 */
        arm_cmplx_mag_f32(testInput_cfft,testOutput,fftSize);
        /* 串口打印求解的模值 */
        for(i = 0; i<TEST_LENGTH_SAMPLES/2; i++) {
            printf("%f\r\n",testOutput[i]);
        }
    } else if(ifftFlag == 1) {
        /* CFFT变换 */
        arm_cfft_f32(&arm_cfft_sR_f32_len1024,testInput_cfft,ifftFlag,doBitReverse);
        /* 串口打印求解的模值 */
        for(i = 0; i<TEST_LENGTH_SAMPLES/2; i++) {
            printf("%f\r\n",testInput_cfft[i*2]);
        }
    }
}

/*
*********************************************************************
* 函数名：arm_rfft_fast_f32_app
* 功能说明：调用函数arm_rfft_fast_f32_app计算幅频
* 形参：无
* 返回值：无
*********************************************************************
*/
static void arm_rfft_fast_f32_app(uint32_t ifftFlag)
{
    uint16_t i;
    arm_rfft_fast_instance_f32 S;
    uint32_t fftSize = 1024;
    arm_rfft_fast_init_f32(&S, fftSize);
    if(ifftFlag == 0) {
        arm_rfft_fast_f32(&S, testInput, testInput_rfft, ifftFlag);
        arm_cmplx_mag_f32(testInput_rfft, testOutput, fftSize);
        for(i=0; i<TEST_LENGTH_SAMPLES/2; i++) {
            printf("%f\r\n", testOutput[i]);
        }
    } else if(ifftFlag == 1) {
        arm_rfft_fast_f32(&S, testInput_rfft, testOutput, ifftFlag);
        for(i=0; i<TEST_LENGTH_SAMPLES/2; i++) {
            printf("%f\r\n", testOutput[i]);
        }
    }
}

/*
*********************************************************************
* 函数名：DSP_Sine_Synthesis
* 功能说明：调用函数arm_sin_f32,生成采样频率1000Hz的50Hz正弦波和200Hz正弦波
* 形参：f1-信号1频率,f2-信号2频率
* 返回值：无
*********************************************************************
*/
static void DSP_Sine_Synthesis(int f1,int f2,int f3,int a1,int a2,int a3)
{
    uint16_t i;
    for(i = 0; i < TEST_LENGTH_SAMPLES; i++) {
        testInput[i] = a1*arm_sin_f32(2*3.1415926f*f1*i/1000) + a2*arm_sin_f32(2*3.1415926f*f2*i/1000) + a3*arm_sin_f32(2*3.1415926f*f3*i/1000);
    }
    for(i = 0; i < TEST_LENGTH_SAMPLES; i++) {
        pc.printf("%f\r\n",testInput[i]);
    }
}

int main()
{
    int f1,f2,f3,a1,a2,a3;
    char str1[10];
    myOLED.init(SH1107G);
    logo:myOLED.clearDisplay();
    while(1) {

        myOLED.drawzifu(1,0,str3_2,16*16/8);        //F
        myOLED.drawzifu(2,0,str3_2,16*16/8);        //F
        myOLED.drawzifu(3,0,str3_3,16*16/8);        //T
        myOLED.drawzifu(4,0,str_bian,16*16/8);      //变
        myOLED.drawzifu(5,0,str_huan,16*16/8);      //换
        myOLED.drawzifu(6,0,str_shi1,16*16/8);      //实
        myOLED.drawzifu(7,0,str_yan1,16*16/8);      //验

        myOLED.drawzifu(2,2,str_deng,16*16/8);      //等
        myOLED.drawzifu(3,2,str_dai,16*16/8);       //待
        myOLED.drawzifu(4,2,str_she,16*16/8);       //设
        myOLED.drawzifu(5,2,str_zhi,16*16/8);       //置
        myOLED.drawzifu(2,3,str_xin,16*16/8);       //信
        myOLED.drawzifu(3,3,str_hao,16*16/8);       //号
        myOLED.drawzifu(4,3,str_can,16*16/8);       //参
        myOLED.drawzifu(5,3,str_shu2,16*16/8);      //数
        pc.scanf("%s",str1);
        if(strcmp(str1,"set_para") == 0) {
            pc.scanf("%d %d %d %d %d %d",&f1,&f2,&f3,&a1,&a2,&a3);              //读取信号参数
            myOLED.drawzifu(2,2,str_xin,16*16/8);           //信
            myOLED.drawzifu(3,2,str_hao,16*16/8);           //号
            myOLED.drawzifu(4,2,str_can,16*16/8);           //参
            myOLED.drawzifu(5,2,str_shu2,16*16/8);          //数
            myOLED.drawzifu(2,3,str_she,16*16/8);           //设
            myOLED.drawzifu(3,3,str_zhi,16*16/8);           //置
            myOLED.drawzifu(4,3,str_wan,16*16/8);           //完
            myOLED.drawzifu(5,3,str_cheng,16*16/8);         //成
            while(1) {
                pc.scanf("%s",str1);
                if(strcmp(str1,"send_data") == 0) {
                    myOLED.drawzifu(2,2,str_zheng,16*16/8);     //正
                    myOLED.drawzifu(3,2,str_zai,16*16/8);       //在
                    myOLED.drawzifu(4,2,str_shang,16*16/8);     //上
                    myOLED.drawzifu(5,2,str_chuan,16*16/8);     //传
                    myOLED.drawzifu(2,3,str_yuan,16*16/8);      //原
                    myOLED.drawzifu(3,3,str_shi2,16*16/8);      //始
                    myOLED.drawzifu(4,3,str_xin,16*16/8);       //信
                    myOLED.drawzifu(5,3,str_hao,16*16/8);       //号

                    DSP_Sine_Synthesis(f1,f2,f3,a1,a2,a3);          //上传原始数据

                    myOLED.drawzifu(2,2,str_xin,16*16/8);       //信
                    myOLED.drawzifu(3,2,str_hao,16*16/8);       //号
                    myOLED.drawzifu(4,2,str_shu2,16*16/8);      //数
                    myOLED.drawzifu(5,2,str_ju,16*16/8);        //据
                    myOLED.drawzifu(2,3,str_shang,16*16/8);     //上
                    myOLED.drawzifu(3,3,str_chuan,16*16/8);     //传
                    myOLED.drawzifu(4,3,str_wan,16*16/8);       //完
                    myOLED.drawzifu(5,3,str_cheng,16*16/8);     //成
                    while(1)  {
                        pc.scanf("%s",str1);
                        if(strcmp(str1,"cfft_data") == 0) {
                            myOLED.clearDisplay();
                            myOLED.drawzifu(2,1,str_bian,16*16/8);      //变
                            myOLED.drawzifu(3,1,str_huan,16*16/8);      //换
                            myOLED.drawzifu(4,1,str_lei,16*16/8);       //类
                            myOLED.drawzifu(5,1,str_xing,16*16/8);      //型
                            
                            myOLED.drawzifu(2,2,str_fu,16*16/8);        //复
                            myOLED.drawzifu(3,2,str_shu2,16*16/8);      //数
                            myOLED.drawzifu(4,2,str3_2,16*16/8);        //F
                            myOLED.drawzifu(5,2,str3_2,16*16/8);        //F
                            myOLED.drawzifu(6,2,str3_3,16*16/8);        //T

                            myOLED.drawzifu(2,4,str_zheng,16*16/8);     //正
                            myOLED.drawzifu(3,4,str_zai,16*16/8);       //在
                            myOLED.drawzifu(4,4,str_shang,16*16/8);     //上
                            myOLED.drawzifu(5,4,str_chuan,16*16/8);     //传
                            myOLED.drawzifu(2,5,str_shi1,16*16/8);      //实
                            myOLED.drawzifu(3,5,str_yan1,16*16/8);      //验
                            myOLED.drawzifu(4,5,str_shu2,16*16/8);      //数
                            myOLED.drawzifu(5,5,str_ju,16*16/8);        //据

                            arm_cfft_f32_app(0);

                            myOLED.drawzifu(2,4,str_shi1,16*16/8);      //实
                            myOLED.drawzifu(3,4,str_yan1,16*16/8);      //验
                            myOLED.drawzifu(4,4,str_shu2,16*16/8);      //数
                            myOLED.drawzifu(5,4,str_ju,16*16/8);        //据
                            myOLED.drawzifu(2,5,str_shang,16*16/8);     //上
                            myOLED.drawzifu(3,5,str_chuan,16*16/8);     //传
                            myOLED.drawzifu(4,5,str_wan,16*16/8);       //完
                            myOLED.drawzifu(5,5,str_cheng,16*16/8);     //成
                            while(1) {
                                pc.scanf("%s",str1);
                                if(strcmp(str1,"cifft_data") == 0) {
                                    myOLED.clearDisplay();
                                    myOLED.drawzifu(2,1,str_bian,16*16/8);    //变
                                    myOLED.drawzifu(3,1,str_huan,16*16/8);    //换
                                    myOLED.drawzifu(4,1,str_lei,16*16/8);     //类
                                    myOLED.drawzifu(5,1,str_xing,16*16/8);    //型

                                    myOLED.drawzifu(1,2,str_fu,16*16/8);      //复
                                    myOLED.drawzifu(2,2,str_shu2,16*16/8);    //数
                                    myOLED.drawzifu(3,2,str_i,16*16/8);       //I
                                    myOLED.drawzifu(4,2,str3_2,16*16/8);      //F
                                    myOLED.drawzifu(5,2,str3_2,16*16/8);      //F
                                    myOLED.drawzifu(6,2,str3_3,16*16/8);      //T

                                    myOLED.drawzifu(2,4,str_zheng,16*16/8);   //正
                                    myOLED.drawzifu(3,4,str_zai,16*16/8);     //在
                                    myOLED.drawzifu(4,4,str_shang,16*16/8);   //上
                                    myOLED.drawzifu(5,4,str_chuan,16*16/8);   //传
                                    myOLED.drawzifu(2,5,str_shi1,16*16/8);    //实
                                    myOLED.drawzifu(3,5,str_yan1,16*16/8);    //验
                                    myOLED.drawzifu(4,5,str_shu2,16*16/8);    //数
                                    myOLED.drawzifu(5,5,str_ju,16*16/8);      //据
                                    arm_cfft_f32_app(1);
                                    myOLED.drawzifu(2,4,str_shi1,16*16/8);    //实
                                    myOLED.drawzifu(3,4,str_yan1,16*16/8);    //验
                                    myOLED.drawzifu(4,4,str_shu2,16*16/8);    //数
                                    myOLED.drawzifu(5,4,str_ju,16*16/8);      //据
                                    myOLED.drawzifu(2,5,str_shang,16*16/8);   //上
                                    myOLED.drawzifu(3,5,str_chuan,16*16/8);   //传
                                    myOLED.drawzifu(4,5,str_wan,16*16/8);     //完
                                    myOLED.drawzifu(5,5,str_cheng,16*16/8);   //成
                                    wait(5);
                                    goto logo;
                                }
                            }
                        } else if(strcmp(str1,"rfft_data") == 0) {
                            myOLED.clearDisplay();
                            myOLED.drawzifu(2,1,str_bian,16*16/8);      //变
                            myOLED.drawzifu(3,1,str_huan,16*16/8);      //换
                            myOLED.drawzifu(4,1,str_lei,16*16/8);       //类
                            myOLED.drawzifu(5,1,str_xing,16*16/8);      //型
                            
                            myOLED.drawzifu(2,2,str_shi1,16*16/8);        //实
                            myOLED.drawzifu(3,2,str_shu2,16*16/8);      //数
                            myOLED.drawzifu(4,2,str3_2,16*16/8);        //F
                            myOLED.drawzifu(5,2,str3_2,16*16/8);        //F
                            myOLED.drawzifu(6,2,str3_3,16*16/8);        //T

                            myOLED.drawzifu(2,4,str_zheng,16*16/8);   //正
                            myOLED.drawzifu(3,4,str_zai,16*16/8);     //在
                            myOLED.drawzifu(4,4,str_shang,16*16/8);   //上
                            myOLED.drawzifu(5,4,str_chuan,16*16/8);   //传
                            myOLED.drawzifu(2,5,str_shi1,16*16/8);    //实
                            myOLED.drawzifu(3,5,str_yan1,16*16/8);    //验
                            myOLED.drawzifu(4,5,str_shu2,16*16/8);    //数
                            myOLED.drawzifu(5,5,str_ju,16*16/8);      //据
                            arm_rfft_fast_f32_app(0);
                                    myOLED.drawzifu(2,4,str_shi1,16*16/8);    //实
                                    myOLED.drawzifu(3,4,str_yan1,16*16/8);    //验
                                    myOLED.drawzifu(4,4,str_shu2,16*16/8);    //数
                                    myOLED.drawzifu(5,4,str_ju,16*16/8);      //据
                                    myOLED.drawzifu(2,5,str_shang,16*16/8);   //上
                                    myOLED.drawzifu(3,5,str_chuan,16*16/8);   //传
                                    myOLED.drawzifu(4,5,str_wan,16*16/8);     //完
                                    myOLED.drawzifu(5,5,str_cheng,16*16/8);   //成
                            while(1) {
                                pc.scanf("%s",str1);
                                if(strcmp(str1,"rifft_data") == 0) {
                                    myOLED.clearDisplay();
                                    myOLED.drawzifu(2,1,str_bian,16*16/8);    //变
                                    myOLED.drawzifu(3,1,str_huan,16*16/8);    //换
                                    myOLED.drawzifu(4,1,str_lei,16*16/8);     //类
                                    myOLED.drawzifu(5,1,str_xing,16*16/8);    //型

                                    myOLED.drawzifu(1,2,str_shi1,16*16/8);    //实
                                    myOLED.drawzifu(2,2,str_shu2,16*16/8);    //数
                                    myOLED.drawzifu(3,2,str_i,16*16/8);       //I
                                    myOLED.drawzifu(4,2,str3_2,16*16/8);      //F
                                    myOLED.drawzifu(5,2,str3_2,16*16/8);      //F
                                    myOLED.drawzifu(6,2,str3_3,16*16/8);      //T
                                    
                                    myOLED.drawzifu(2,4,str_zheng,16*16/8);   //正
                                    myOLED.drawzifu(3,4,str_zai,16*16/8);     //在
                                    myOLED.drawzifu(4,4,str_shang,16*16/8);   //上
                                    myOLED.drawzifu(5,4,str_chuan,16*16/8);   //传
                                    myOLED.drawzifu(2,5,str_shi1,16*16/8);    //实
                                    myOLED.drawzifu(3,5,str_yan1,16*16/8);    //验
                                    myOLED.drawzifu(4,5,str_shu2,16*16/8);    //数
                                    myOLED.drawzifu(5,5,str_ju,16*16/8);      //据
                                    arm_rfft_fast_f32_app(1);
                                    myOLED.drawzifu(2,4,str_shi1,16*16/8);    //实
                                    myOLED.drawzifu(3,4,str_yan1,16*16/8);    //验
                                    myOLED.drawzifu(4,4,str_shu2,16*16/8);    //数
                                    myOLED.drawzifu(5,4,str_ju,16*16/8);      //据
                                    myOLED.drawzifu(2,5,str_shang,16*16/8);   //上
                                    myOLED.drawzifu(3,5,str_chuan,16*16/8);   //传
                                    myOLED.drawzifu(4,5,str_wan,16*16/8);     //完
                                    myOLED.drawzifu(5,5,str_cheng,16*16/8);   //成
                                    wait(5);
                                    goto logo;
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}