// example code on how to wake from sleep mode after a fixed period of time.

// Normal sleep we can use a timer but there isn't a huge power saving.

// DeepSleep or PowerDown we need to use the watchdog (via the WakeUp library)

#include "mbed.h"
#include "mBuinoSleep.h"
#include "WakeUp.h"
#include "L6470.h"

//SPI_MOSI is P0.21
//SPI_MISO is P0.22
//SPI_SCK is P1.15
//D10 is CS is P.11 (or another free pin)

//L6470SDC l6470(P0_21,    P0_22,    P1_15, P0_11);
L6470 Step(P0_21,    P0_22,    P1_15, P0_11, P0_15 );//mosi,miso,sck,#cs,busy(PullUp)

InterruptIn ActionButton(P0_4);  // declare the input for the button (or for other single switch, such as movement switch). On mBuino P0.4 is close to GND

  
void interruptButtonPressed()
{
       wait(0.5);
       LEDs = 127;
       wait(0.5);
       LEDs = 0;
       wait(0.5);
       LEDs = 127;
       wait(0.5);
       LEDs = 0;
       wait(0.5);
       LEDs = 127;
       wait(0.5);
       LEDs = 127;
       wait(0.5);
       LEDs = 0;
       wait(0.5);
       LEDs = 127;
       wait(0.5);
       LEDs = 0;
       wait(0.5);
       LEDs = 127;
 }   
 
void blink(int count, int diode) {
     int lednr = 1<<diode; 
     
     for(int i = 1; i <= count; i++) {
       LEDs = lednr;
       wait(0.2);
       LEDs = 0;
       wait(0.2);
               
       }
       
        
}
        
int main ()
{
    blink(5,0);
    ActionButton.fall(interruptButtonPressed); // using the fall requires the button to be unpressed before the interrupt is triggered again
    blink(5,1);
    WakeUp::calibrate();
    blink(5,2);
    Step.Resets();
    Step.ReleseSW(0,1);//
    Step.Run(0, 30); 
    blink(5,3);

    while (1) {
        wait(0.1);
        WakeUp::set_ms(1000*5);
        mBuinoSleep(PowerDownWD);
        if (LEDs == 127)
            LEDs = 1;
        else
            LEDs = LEDs + 1;
    }
}
