#include "mbed.h"
#include "idDHTLib.h"
#include "USBSerial.h"

DigitalOut myled(LED1);
//Virtual serial port over USB
USBSerial serial;

void dhtWrapper();
idDHTLib DHTLib(P1_24, dhtWrapper);

void dhtWrapper()
{
    DHTLib.dht11Callback(); // change do dht11Callback if needed
}

void readDht()
{
    if(!DHTLib.acquiring())  DHTLib.acquire();
}

int main()
{
    float humidity;
    float temperature;
    wait(10);
    serial.printf("\r\nDHT Test program");
    serial.printf("\r\n******************\r\n");
    wait(1); // wait 1 second for device stable status
    DHTLib.acquireAndWait();
    while (1) {
        myled = 1;
        readDht();
        humidity = DHTLib.getHumidity();
        temperature = DHTLib.getCelsius();
        serial.printf("Status is %i\r\n",DHTLib.getStatus());
        serial.printf("Temperature is %4.2f C \r\n",temperature);
        serial.printf("Humidity is %4.2f \r\n",humidity);

        myled = 0;
        wait(10);
    }

}