

#include "mbed.h"
#include "const.h"
#include "Robot.h"

Robot bertl;

void Los()
{
    bertl.Move();
}

void HexLed(int value)
{
    bertl.NibbleLeds(value);
}

void LedAn(int16_t led)
{
    bertl.TurnLedOn(LED_FR1);
}

void LedAus(int16_t led)
{
    bertl.TurnLedOff(LED_FR1);
}

void RGB(bool rot, bool gruen, bool blau)
{
    bertl.RGBLed(rot, gruen, blau);
}

void BlaueLedAn()
{
    bertl.BlueLedsON();
}
void BlaueLedAus()
{
    bertl.BlueLedsOFF();
}

void DrehLinks()
{
    bertl.TurnLeft();  
}

bool WarteBisKnopfGedrueckt()
{
    bertl.WaitUntilButtonPressed();
}

bool VorneKlar()
{
    bertl.FrontIsClear();
}

bool NebenBiper()
{
    return bertl.NextToABeeper();   
}

bool IstKnopfGedrueckt(const int btn)
{
    return bertl.IsButtonPressed(btn)
}

bool KnopfGedruecktZurueckgeben()
{
    return bertl.ReturnButtonPressed();   
}

int main()
{
    Los();
    HexLed(4);
    LedAn(LED_FR1);
    LedAus(LED_FR1);
    RGB(1, 1, 1);
    BlaueLedAn();
    BlaueLedAus();
    DrehLinks();
    WarteBisKnopfGedrueckt();
    VorneKlar();
    NebenBiper();
    IstKnopfGedrueckt(BT_BR);
    KnopfGedruecktZurueckgeben();
}