#include "mbed.h"
#define bitRead(value, bit) (((value) >> (bit)) & 0x01)
#define bitSet(value, bit) ((value) |= (1UL << (bit)))
#define bitClear(value, bit) ((value) &= ~(1UL << (bit)))
#define bitWrite(value, bit, bitvalue) (bitvalue ? bitSet(value, bit) : bitClear(value, bit))
#define left (bitRead (DT[2],3))
#define right (bitRead (DT[2],2))
#define up (bitRead (DT[2],0))
#define down (bitRead (DT[2],1))
#define sqare (bitRead (DT[1],0))
#define circle (bitRead (DT[2],6))
#define participation (bitRead (DT[2],4))
#define xmark (bitRead (DT[2],5))
#define l1 (bitRead (DT[1],1))
#define l2 (bitRead (DT[1],2))
#define r1 (bitRead (DT[1],3))
#define r2 (bitRead (DT[1],4))
Serial pc(USBTX,USBRX,115200); //tx, rx
Serial SBDBT(D1,D0,115200);    //tx, rx
int DT[8];
int DT_joy[8];
long map(long x, long in_min, long in_max, long out_min, long out_max) {
  return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}
void SBDBT_rx(){
    for(int i = 0; i < 8;i++){
        DT[i] = SBDBT.getc();
    }
    for(int i=3;i<7;i++){
        DT[i] = map(DT[i],0,255,-128,128);
    }
}
void pc_tx(){
    for(int i = 3; i <7;i++){
        pc.printf(" %3d",DT[i]*-1);
    }
    if(left){
        pc.printf(" left");
    }
    if(right){
        pc.printf(" right");
    }
    if(up){
        pc.printf(" up");
    }
    if(down){
        pc.printf(" down");
    }
    if(sqare){
        pc.printf(" sqare");
    }
    if(circle){
        pc.printf(" circle");
    }
    if(participation){
        pc.printf(" participation");
    }
    if(xmark){
        pc.printf(" xmark");
    }
    if(l1){
        pc.printf(" L1");
    }
    if(l2){
        pc.printf(" L2");
    }
    if(r1){
        pc.printf(" R1");
    }
    if(r2){
        pc.printf(" R2");
    }
    pc.printf("\n");
}
int main (){
    SBDBT.attach(SBDBT_rx,Serial::RxIrq); //割り込み
    while(1){
        pc_tx();
    }  
}