#include "mbed.h"

#define MIN_SV_PULSE 0.475 //最小パルス幅 0.475ms
#define MAX_SV_PULSE 2.475 //最大パルス幅 2.475ms
#define SV_PERIOD 0.020    //PWM周期20ms, 周波数50Hz
#define MAX_ANGLE 180      //最大動作角度
//D4ピンをPWM出力ピン servo1ピンとして宣言
PwmOut servo1(D4);
//パソコンとの通信用にpcクラスを宣言(デフォルトでは通信速度は9600bps)
Serial pc(USBTX, USBRX);

//パルス幅(s)を取得する関数
float get_pulse_width(int angle){
  float pulseMs = (MIN_SV_PULSE + (MAX_SV_PULSE - MIN_SV_PULSE) * angle / MAX_ANGLE) / 1000;
  return(pulseMs);
}

int main(void){
    servo1.period(SV_PERIOD);
    pc.printf("START\n");
    while(1){
        for(int angle = 0; angle < MAX_ANGLE; angle += 10) {
            servo1.pulsewidth(get_pulse_width(angle));
            wait_ms(40);
            pc.printf("angle = %d, pulse_width = %f\n", angle, get_pulse_width(angle));
        }
        for(int angle = MAX_ANGLE; angle >= 0; angle -= 10) {
            servo1.pulsewidth(get_pulse_width(angle));
            wait_ms(40);
            pc.printf("angle = %d, pulse_width = %f\n", angle, get_pulse_width(angle));
        }
    }
}