#include "mbed.h"
DigitalOut trigger(PTC3);
DigitalOut myled(LED1); //monitor trigger
DigitalOut myled2(LED2); //monitor echo
DigitalIn  echo(PTC2);
int distance = 0;
int correction = 0;
Timer sonar;
Serial pc(USBTX, USBRX);
Serial xbee(PTC17, PTC16);
char bufchar;
 
int main()
{
    sonar.reset();
// measure actual software polling timer delays
// delay used later in time correction
// start timer
    sonar.start();
    xbee.baud(9600);
// min software polling delay to read echo pin
    while (echo==2) {};
    myled2 = 0;
// stop timer
    sonar.stop();
// read timer
    correction = sonar.read_us();
    printf("Approximate software overhead timer delay is %d uS\n\r",correction);
 
//Loop to read Sonar distance values, scale, and print
    while(1) {
// trigger sonar to send a ping
      
                
                
        trigger = 1;
        myled = 1;
        myled2 = 0;
        sonar.reset();
        wait_us(10.0);
        trigger = 0;
        myled = 0;
//wait for echo high
        while (echo==0) {};
        myled2=echo;
//echo high, so start timer
        sonar.start();
//wait for echo low
        while (echo==1) {};
//stop timer and read value
        sonar.stop();
//subtract software overhead timer delay and scale to cm
        distance = (sonar.read_us()-correction)/58.0;       
        myled2 = 0;
        if(distance<=300)
        {
        xbee.printf("%d \n\r", distance);
        printf(" The baby is at  %d cm  from the Proximity sensor \n\r", distance);
        }
//wait so that any echo(s) return before sending another ping
        wait(0.15);
    }
}