#include "mbed.h"
#include "rtos.h"
#include "niMQTT.h"
#include "EthernetInterface.h"

EthernetInterface eth;

DigitalOut led(LED1);
DigitalIn pub(p14);

void callback(const char *topic, const char *message) {
    printf("==== New PUBLISH received ====\r\n");
    printf(topic);
    printf("\r\n------------------------------\r\n");
    printf(message);
    printf("\r\n------------ end -------------\r\n");
}

int main() {
    printf("\r\n====================================================\r\n");
    eth.init();
    do printf("Connection...\r\n"); while (eth.connect() != 0);
    
    niMQTT client("10.41.51.53", callback);
    
    client.pub("mbed", "Hello World");
        
    client.sub("mbed", false);
    
    while(true) {
        if (pub) client.pub("mbed", "test");
        led = 0;
        wait(1);
        led = 1;
        wait(1);
    }
}