#include "mbed.h"
#include "rtos.h"
#include "AV_MQTT.h"
#include "EthernetInterface.h"

EthernetInterface eth;

DigitalIn jdown(p12), jleft(p13), jcenter(p14), jup(p15), jright(p16);
DigitalOut l1(LED1), l2(LED2), l3(LED3), l4(LED4);

void callback(const char *key, const char *value) {
    int led = atoi(value);
    l4 = (led & 4) >> 2;
    l3 = (led & 2) >> 1;
    l2 = led & 1;
}

int main() {
    printf("\r\n====================================================\r\n");
    eth.init();
    do printf("Connection...\r\n"); while (eth.connect() != 0);
    
    AV_MQTT client("10.41.240.6", callback, "MBED_MQTT_EXAMPLE", "mbed_password", "id", 1883, false);
    
    
    while(true) {
        
        if (jdown)        client.pub("button", "1");
        else if (jleft)   client.pub("button", "2");
        else if (jcenter) client.pub("button", "3");
        else if (jup)     client.pub("button", "4");
        else if (jright)  client.pub("button", "5");
        
        l1 = 0;
        wait(1);
        l1 = 1;
        wait(1);
    }
}