#include "mbed.h"
#include "SHTx/sht15.hpp"
#include "Adafruit_SSD1306.h"
#include "MPL3115A2.h"
#include<stdio.h>

//Puertos serial
Serial pc(USBTX,USBRX);
Serial mm(p13,p14);

//Sensores
SHTx::SHT15 sensor(p21, p22); //Humedad sht
I2C i2c(p28, p27);
//MPL3115A2 sensors(&i2c, &pc);  //Altitud
I2C myI2C(p9,p10); //Display
Adafruit_SSD1306_I2c o(myI2C,D13,0x7A,64,128);



int main() {
    //sensors.init(); //Para sensor de altitud
    //Altitude a;
    //sensors.setOffsetAltitude(83);
    sensor.setOTPReload(false);
    sensor.setResolution(true);
    mm.baud(9600);
    while(1) {
         sensor.update(); //Humedad sht
         //sensors.readAltitude(&a);
        
         
         //Imprimir valores
         char buffer[100];
         char buffers[100];
         mm.gets(buffer, 100);
         for(int h=0; h<=100; h++)
         {
            if(buffer[h] == '@'){
            for(int t=0; t<=100; t++)
            {
            buffers[t]=buffer[h];
            h++;
            if(buffer[h] == '#')
            {
            h=101;
            t=101;
                }
            
            }}}
            //pc.printf("%c", buffers[h]);  
            //pc.printf("%c", buffer[h]);
          
         //pc.printf("\nSensor de humedad\nTemperature: [ %3.2f C ]\n", sensor.getTemperature()); 
         //pc.printf("Humdity:[ %3.2f %% ]\r\r\r\n\n", sensor.getHumidity()); //Humedad sht
         
         //pc.printf(" '%s'\n", buffers);  

         //pc.printf("Altitude: %s#\r\n", a.print());
         
         //.printf ("%s\n",buffer);
         mm.printf("%s", buffers);
         mm.printf(",%2.2f,%3.1f, #\n", sensor.getTemperature(),sensor.getHumidity());
         //mm.printf("%s,#", a.print());
        
        o.setTextCursor(0,0);
        o.clearDisplay();
        o.printf("%s", buffers);
        o.printf(",%2.2f,%3.1f, #\n", sensor.getTemperature(),sensor.getHumidity());
        //o.printf("%s,#", a.print());
        
        o.display();
         }
         
}