#include "SDFileSystem.h"
#include "JPEGCamera.h"
#include "L3GD20.h"
#include "LSM303DLHC.h"
#include "BMP180.h"
#include<stdio.h>
#include<string.h> 
#include "mbed.h"
#include <math.h>  


//Puertos serial
Serial pc(USBTX,USBRX);
Serial mm(p28,p27);

//Sensores
I2C myI2C(p9,p10);
L3GD20 gyro(p9, p10);
LSM303DLHC compass(p9, p10);
BMP180 bmp180(&myI2C); //IMU
AnalogIn uv(p16); //Uv
AnalogIn alc(p17); //Alcohol
AnalogIn met(p18);//metano
AnalogIn lpg(p19);//lpg
AnalogIn Vol(p20); //Voltaje

//Camara
JPEGCamera camera(p13, p14); // TX, RX

//SD
SDFileSystem sd(p5, p6, p7, p8, "sd");
#define archivof "/sd/fotos/pic%05d.jpg";
#define archivod "/sd/datos/dato%05d.txt";

//Variables

float uv_rad=0; //UV
float ax, ay, az;
float mx, my, mz;
float gx, gy, gz;
double yaw,pitch,roll;
int press;
float temp;//IMU
float voltaje; //Voltaje
float calc;//Alcohol
float cmet;//metano
float clpg;//Lpg
int conta;

#define     M_PI   3.14159265358979323846



int main() {
    mm.baud(9600);
    //Camara
    LocalFileSystem local("local"); //save images on mbed
    Timer timer;
    timer.start();
    camera.setPictureSize(JPEGCamera::SIZE320x240);
    conta=0;
    mkdir("/sd/fotos", 0777);     
    mkdir("/sd/datos", 0777);
    while(1) {
         
         conta+= 1;
         //UV
         uv_rad=((uv.read()*3.3)-1)/0.125;
         if(uv_rad<0)uv_rad=0; 
         //Voltaje
         voltaje=(Vol.read()*3.3)/(.2423);
         
         //GASES
         //Alcohol
         calc=(alc.read()*3.3);
         //Metano
         cmet=(met.read()*3.3);
         //Lpg
         clpg=(lpg.read()*3.3);
         
        
         //IMU
         bmp180.init();
         compass.read(&ax, &ay, &az, &mx, &my, &mz);
         gyro.read(&gx, &gy, &gz);
         roll=atan2(ay, az);        
         pitch=atan((-ax)/(ay*sin(roll)+az*cos(roll)));
         yaw=atan2(mz*sin(roll)-my*cos(roll),mx*cos(pitch)+my*sin(pitch)*sin(roll)+mz*sin(pitch)*cos(roll));
         bmp180.startTemperature();
         wait_ms(5);     // Wait for conversion to complete
         if(bmp180.getTemperature(&temp) != 0) {pc.printf("Error getting temperature\n");}
         bmp180.startPressure(BMP180::ULTRA_LOW_POWER);
         wait_ms(10);    // Wait for conversion to complete
         if(bmp180.getPressure(&press) != 0) {pc.printf("Error getting pressure\n");} 
         
         //Camara
         
         if (camera.isReady()) {
            char filename[32];
            //sprintf(filename, "/local/pict%03d.jpg", conta);
            sprintf(filename, "/sd/fotos/pic%05d.jpg", conta);
            pc.printf("Picture: %s ", filename);
            mm.printf("Picture taken");
            if (camera.takePicture(filename)) {
                while (camera.isProcessing()) {
                    camera.processPicture();
                }
                wait(2.0);
            } else {
                pc.printf("take picture failed\n");
                mm.printf("Picture failed\n");
                wait(2.0);
            }
        } else {
            pc.printf("camera is not ready\n");
            mm.printf("Picture failed\n");
            
            wait(2.0);
        }
         
         
         char fil[32];
         sprintf(fil, "/sd/datos/dato%05d.txt", conta); 
         FILE *fp = fopen(fil, "w");
         
         //Imprimir valores
         pc.printf("\nSensor UV\nUV=%.3fmW/cm^2\n\r",uv_rad);//UV
         pc.printf("\nGiroscopo\nr:%.1f  p:%.1f  y:%.1f\n\r",roll*180/M_PI,pitch*180/M_PI,yaw*180/M_PI);
         pc.printf("P=%d Pa\n\rT=%.2fC\n\r", press, temp); //IMU
         pc.printf("Sensor Voltaje\nVoltaje:%f V\n\r",voltaje);//Voltaje
         pc.printf("Sensor Alcohol\nCantidad:%f mg/l\n\r",calc);//Alcohol
         pc.printf("Sensor Metano\nCantidad:%f mg/l\n\r",cmet);//Metano
         pc.printf("Sensor LPG\nCantidad:%f mg/l\n\r",clpg);//LPG
         pc.printf("Sensor de altitud: %.3f", (44330.77)*(1.0-(pow((float)(press/101326.0),(float)0.1902632))));//altitud
         
          //Imprimir en sd
         fprintf(fp,"\nSensor UV\nUV=%.3fmW/cm^2\n\r",uv_rad);//UV
         fprintf(fp,"\nGiroscopo\nr:%.1f  p:%.1f  y:%.1f\n\r",roll*180/M_PI,pitch*180/M_PI,yaw*180/M_PI);
         fprintf(fp,"P=%d Pa\n\rT=%.2fC\n\r", press, temp); //IMU
         fprintf(fp,"Sensor Voltaje\nVoltaje:%f V\n\r",voltaje);//Voltaje
         fprintf(fp,"Sensor Alcohol\nCantidad:%f mg/l\n\r",calc);//Alcohol
         fprintf(fp,"Sensor Metano\nCantidad:%f mg/l\n\r",cmet);//Metano
         fprintf(fp,"Sensor LPG\nCantidad:%f mg/l\n\r",clpg);//LPG
         fprintf(fp, "Sensor de altitud: %.3f", (44330.77)*(1.0-(pow((float)(press/101326.0),(float)0.1902632))));//altitud
        
        //Imprimir en cadena
        mm.printf("@,%1.3f,",uv_rad);
        mm.printf("%.1f, %.1f, %.1f,",roll*180/M_PI,pitch*180/M_PI,yaw*180/M_PI);
        mm.printf("%d, %.2f,",press, temp);  
        mm.printf("%2.1f,",voltaje);
        mm.printf("%.3f,",calc);
        mm.printf("%.3f,",cmet);
        pc.printf("%.3f,",clpg);//LPG
        mm.printf("%.3f,", (44330.77)*(1.0-(pow((float)(press/101326.0),(float)0.1902632))));//altitud
        mm.printf("%.3f #",clpg);
        wait( 1 );
        
        timer.reset();
       fclose(fp);
    }
}