#ifndef TMP102_H
#define TMP102_H

//address for ADD0 connected to GND
#define TMP102_ADD 0x48
#define TMP102_R_ADD 0x91
#define TMP102_W_ADD 0x90

//register addresses

#define TEMP_REG 0x00
#define CONF_REG 0x01
#define THIGH_REG 0x02
#define TLOW_REG 0x03

#include "mbed.h"

class TMP102

//define the methods that are public, which could be used by the user

 public:
 
TMP102(PinName sda, PinName scl);

void init();

float get_temperature;

//define private methods, could be used in the library itself, but could not called by the user

void error();

void read_temperature();

public:

private:

I2C* i2c_;
DigitalOut* led;
float temperature_;

#endif


