//Envirennement mbed
#include "mbed.h"

//Capteurs
#include "Lum_sensor.h"                        //inclusion de la classe capteur de luminosité
#include "Sound_sensor.h"                      //inclusion de la classe capteur de son 
#include "TempHum_sensor.h"                    //inclusion de la classe capteur de température et humidité


//Librairie mDot
#include "mDot.h"
#include "MTSText.h"
#include "MTSLog.h"
#include <iostream>
#include <fstream>
#include <string>
#include <cmath>
#include <vector>
#include <sstream>
#include <cstdio>


namespace patch
{
    template < typename T > std::string to_string( const T& n )
    {
        std::ostringstream stm ;
        stm << n ;
        return stm.str() ;
    }
}



void log_error(mDot* dot, const char* msg, int32_t retval);


 
// Configuration du Reseau de la Gateway 
// On peut aussi directement donner la clé, et l'ID du réseau
static std::string config_network_name = "digora2017";
static std::string config_network_pass = "digora2017";


int main() 
{

    float son = 0;
    float Temperature = 0;
    float Hum = 0;
    float Luminosity = 0;
    
    Capt_Son SON;                              //initialisation capteur luminosité
    Capt_Lum LUM;                              //initialisation capteur son
    Capt_TH TH;                                //initialisation capteur température et humidité
    printf("\n\n\r#################################\n\rInitialisation capteurs OK\n\r#################################\n\r");  
    



    //----------    CONNEXION A LA GATEWAY   ----------


    int32_t ret;
    mDot* dot = NULL;
    std::vector<uint8_t> data;
    std::vector<uint8_t> data_recv;
    std::string data_str;
 
    /** Get a handle to the singleton object
     * @returns pointer to mDot object
     */

    dot = mDot::getInstance();
 
    /** Reset config to factory default
     */
    dot->resetConfig();

    /** Resets current network session, essentially disconnecting from the network
     * has no effect for MANUAL network join mode
     */
    dot->resetNetworkSession();

    /** Get library version information
     * @returns string containing library version information
     */
    printf("version: %s\r\n", dot->getId().c_str());
 

    /** Set network join mode
     * MANUAL: set network address and session keys manually
     * OTA: User sets network name and passphrase, then attempts to join
     * AUTO_OTA: same as OTA, but network sessions can be saved and restored
     * @param mode MANUAL, OTA, or AUTO_OTA
     * @returns MDOT_OK if success
     */
    if (dot->getJoinMode() != mDot::OTA) 
    {
        logInfo("changing network join mode to OTA");
        if (dot->setJoinMode(mDot::AUTO_OTA) != mDot::MDOT_OK) 
        {
            logError("failed to set network join mode to OTA");
        }
    }


    /** Set network name
     * for use with OTA & AUTO_OTA network join modes
     * generates network ID (crc64 of name) automatically
     * @param name a string of of at least 8 bytes and no more than 128 bytes
     * @return MDOT_OK if success
     */
    printf("setting network name...\r\n");
    if ((ret = dot->setNetworkName(config_network_name)) != mDot::MDOT_OK) 
    {
        log_error(dot, "failed to set network name", ret);
    }

    /** Set network passphrase
     * for use with OTA & AUTO_OTA network join modes
     * generates network key (cmac of passphrase) automatically
     * @param name a string of of at least 8 bytes and no more than 128 bytes
     * @return MDOT_OK if success
     */
    printf("setting network password...\r\n");
    if ((ret = dot->setNetworkPassphrase(config_network_pass)) != mDot::MDOT_OK) 
    {
        log_error(dot, "failed to set network password", ret);
    }

    /** Set the device class A, B or C
     *  @returns MDOT_OK if success
     */
    logInfo("changing network mode to class C");
    if (dot->setClass("C") != mDot::MDOT_OK) 
    {
        logError("failed to set network mode to class C");
    }
    
    

    /** Save config data to non volatile memory
     * @returns true if success, false if failure
     */
    logInfo("saving configuration");
    if (!dot->saveConfig()) 
    {
        logError("failed to save configuration");
    }

    /** Attempt to join network
     * each attempt will be made with a random datarate up to the configured datarate
     * JoinRequest backoff between tries is enforced to 1% for 1st hour, 0.1% for 1-10 hours and 0.01% after 10 hours
     * Check getNextTxMs() for time until next join attempt can be made
     * @returns MDOT_OK if success
     */
    
    uint8_t freq = dot->getFrequencyBand();
    printf("freq : %u\n\r", freq);   //Set frequency sub band
    printf("joining network\r\n");


    while ((ret = dot->joinNetwork()) != mDot::MDOT_OK) 
    {
        log_error(dot, "failed to join network", ret);
        wait(2);
    }
    string type;
    
    //############    RELEVE DE MESURES     ############
    
    while(true)
    {
        printf("\n\n");                        
        TH.getTempHum();                       //mesure de la température et de l'humidité
        TH.obtenirTemperature();               //affichage de la température
        TH.obtenirHumidite();                  //affichage de l'humidité 
        LUM.obtenirLuminosite();               //mesure et affichage de la luminosité
        SON.obtenirSon();                      //mesure et affichage du niveau sonore
        
    //##################################################
        
        
        //-------- ENVOI SON --------   
    
        data_str = patch::to_string(son);
        /**
         * Fill the vector that we will send with the data
        */
        for (std::string::iterator it = data_str.begin(); it != data_str.end(); it++)
            data.push_back((uint8_t) *it);
        type = ":dB";
        for (std::string::iterator it = type.begin(); it != type.end(); it++)
            data.push_back((uint8_t) *it);
    
        /** Send data to the gateway
         * validates data size (based on spreading factor)
         * @param data a vector of up to 242 bytes (may be less based on spreading factor)
         * @returns MDOT_OK if packet was sent successfully (ACKs disabled), or if an ACK was received (ACKs enabled)
         */
        if ((ret = dot->send(data)) != mDot::MDOT_OK) 
        {
            log_error(dot, "failed to send", ret);
        } 
        
        else 
        {
            printf("successfully sent data to gateway\r\n");
        }
        
        data_str.clear();
        data.clear();
        
        wait(10);
        
        //-------- ENVOI TEMPERATURE --------
        
        data_str = patch::to_string(Temperature);
        for (std::string::iterator it = data_str.begin(); it != data_str.end(); it++)
            data.push_back((uint8_t) *it);
        type = ":*C";
        for (std::string::iterator it = type.begin(); it != type.end(); it++)
            data.push_back((uint8_t) *it);
    
        if ((ret = dot->send(data)) != mDot::MDOT_OK) 
        {
            log_error(dot, "failed to send", ret);
        } 
        
        else 
        {
            printf("successfully sent data to gateway\r\n");
        }
        
        data_str.clear();
        data.clear();
        
        wait(10);
    
        //-------- ENVOI HUMIDITE --------
    
        data_str = patch::to_string(Hum);
        for (std::string::iterator it = data_str.begin(); it != data_str.end(); it++)
            data.push_back((uint8_t) *it);
        type = ":%";
        for (std::string::iterator it = type.begin(); it != type.end(); it++)
            data.push_back((uint8_t) *it);
    
        if ((ret = dot->send(data)) != mDot::MDOT_OK) 
        {
            log_error(dot, "failed to send", ret);
        } 
        
        else 
        {
            printf("successfully sent data to gateway\r\n");
        }
        
        data_str.clear();
        data.clear();
        
        wait(10);
    
        //-------- ENVOI LUMINOSITE --------
    
        data_str = patch::to_string(Luminosity);
        for (std::string::iterator it = data_str.begin(); it != data_str.end(); it++)
            data.push_back((uint8_t) *it);
        type = ":Lux";
        for (std::string::iterator it = type.begin(); it != type.end(); it++)
            data.push_back((uint8_t) *it);
    
        if ((ret = dot->send(data)) != mDot::MDOT_OK) 
        {
            log_error(dot, "failed to send", ret);
        } 
        
        else 
        {
            printf("successfully sent data to gateway\r\n");
        }
        
        data_str.clear();
        data.clear();
        
        wait(10);
    }
    
    
    
    //return 0; Jamais atteint à cause du "while(true)", donc inutile...
}


void log_error(mDot* dot, const char* msg, int32_t retval) {
    printf("%s - %ld:%s, %s\r\n", msg, retval, mDot::getReturnCodeString(retval).c_str(), dot->getLastError().c_str());
}