#ifndef TEMPHUM_SENSOR_H
#define TEMPHUM_SENSOR_H

#include "mbed.h"

#define SHT31_ADDR                 0x44    //addresse du capteur     
#define SHT31_WRITE                0x88    //addresse pour écriture
#define SHT31_READ                 0x89    //addresse pour lecture

//les différents registres permettant de varier la fréquence et la répétabilité des mesures
#define SHT31_MEAS_HIGHREP_STRETCH 0x2C06   
#define SHT31_MEAS_LOWREP_STRETCH  0x2C10
#define SHT31_MEAS_HIGHREP         0x2400
#define SHT31_MEAS_MEDREP          0x240B
#define SHT31_MEAS_LOWREP          0x2416


class Capt_TH
{                           
        private:
            I2C i2c;                    //pins I2C initialisés par le constructeur
            float temp;                 //variable dans laquelle on stocke la température mesurée
            float hum;                  //variable dans laquelle on stocke l'humidité mesurée
            uint16_t readbuffer[6];     //tableau d'entiers (buffer) sur 16 bits dans lequel on stocke les valeurs mesurées avant leur conversion en température et humidité
            uint16_t ST, SRH;           //température et humidité avant conversion, récupérées dans le readbuffer
    
        public:
            Capt_TH();                  //constructeur
            void WriteCommand();        //indique au capteur quel type de mesure effectuer
            void ReadTempHum();         //récupère et convertit les données du capteur en température et humidité         
            void getTempHum();          //execute les deux fonctions précedentes
            float obtenirTemperature(); //affiche et retourne la température
            float obtenirHumidite();    //affiche et retourne l'humidité
};

#endif