#include "TempHum_sensor.h"


Capt_TH::Capt_TH() : i2c(PC_9, PA_8)    //initialise la liaison i2c entre le capteur et les pins SDA et SCL du mDot
{
        i2c.frequency(100000);          //on communique à la même fréquence qu'avec le capteur de luminosité
}

void Capt_TH::WriteCommand() 
{
    i2c.start();                        
    i2c.write(0x88);                    // Initialisation du mode écriture à l'adresse 0x44 : 7 bits d'adresse (0x44 = 1000100) 
                                        // + 1 bit de mode (0x88 = 10001000 pour le mode écriture)
    i2c.write(0x24);                    // Premier octet du message 0x240B correspondant au mode MEDIUM REPEATABILITY MEASUREMENT (cf. datasheet)  
    i2c.write(0x0B);                    // Second octet
    i2c.stop();
}

void Capt_TH::ReadTempHum() 
{
    i2c.start();                        
    i2c.write(0x89);                        // Initialisation du mode lecture à l'adresse 0x44 : 7 bits d'adresse (0x44 = 1000100) 
                                            // + 1 bit de mode (0x89 = 10001001 pour le mode lecture)
    
    for (int i=0;i<6;i++)                   // Lecture des données envoyées par le capteur
    {
        readbuffer[i] = i2c.read(1);        // readbuffer[0] et readbuffer[1] contiennent les valeurs de la température
                                            // readbuffer[3] et readbuffer[4] contiennent les valeurs de l'humidité
                                            // readbuffer[2] et readbuffer[5] contiennent des CRC checksum.
    }
    i2c.stop();
    
    
    ST = readbuffer[0];                     // ST contient le bit de poids fort de la température. ex : ST = 01011111 (0x5F)
    ST <<= 8;                               // Décalage de 8 bits pour récupérer les bits de poids faible. ex : 11101010 (0xEA)
    ST |= readbuffer[1];                    // Concaténation des 2 octets, ST = 01011111 11101010 (0x5FEA)

    SRH = readbuffer[3];                    // Même principe pour l'humidité
    SRH <<= 8;
    SRH |= readbuffer[4];

    temp = ST;                              // Conversion de la valeur reçue en degrés Celsius : T = -45 + 175*[ST/(2^16 - 1)]
    temp *= 175;
    temp /= 0xFFFF;
    temp = -45 + temp;
    
    hum = SRH;                              // Conversion de la valeur reçue en humidité relative : RH = 100 * [SRH/(2^16 -1)]
    hum *= 100;
    hum /= 0xFFFF;
}
    
void Capt_TH::getTempHum() 
{
    WriteCommand();                         //indique au capteur quel type de mesure effectuer
    ReadTempHum();                          //récupère et convertit les données du capteur en température et humidité  
}

float Capt_TH::obtenirTemperature()     
{   if (temp<100) {                                         //vérifie la cohérence de la mesure
        printf("\n\rTempérature = %.2f °C\n\r", temp);      //affiche la température en degrés Celsius
    }
    return (temp);                                          //retourne la température pour l'envoi via le réseau LoRa
} 

float Capt_TH::obtenirHumidite() 
{   if (temp<100) {                                         //vérifie la cohérence de la mesure 
        printf("\n\rHumidité Relative = %.2f %%\n\r", hum); //affiche l'humidité relative en pourcentage
        }       
        return (hum);                                      //retourne l'humidité pour l'envoi via le réseau LoRa
}      