#ifndef LUM_SENSOR_H
#define LUM_SENSOR_H

#include "mbed.h"

#define TSL_SLAVE_ADDRESS       0x29      //addresse du capteur                   
#define TSL_CONTROL             0x00      //registre pour allumer et éteindre le capteur                          
#define TSL_TIMING              0x01      //registre contenant les informations sur le gain et le temps d'intégration
#define TSL_THRESHLOWLOW        0x02        
#define TSL_THRESHHIGHLOW       0x04
#define TSL_INTERRUPT           0x06
#define TSL_ID                  0x0A
#define TSL_DATA0LOW            0x0C
#define TSL_DATA1LOW            0x0E

class Capt_Lum
{
        private:
            I2C i2c;                                                //pins I2C initialisés par le constructeur
            float lux;                                              //variable dans laquelle on stocke la luminosité mesurée
        
        public:
            Capt_Lum();                                             //Constructeur
            int enablePower();                                      //allume le capteur
            int disablePower();                                     //éteint le capteur
            int writeSingleRegister( char A, char B);               //écrit le mot B à l'addresse A
            int readMultipleRegisters( char A, char* B, int N);     //recopie N mots lus dans le registre d'addresse A dans le tableau d'adresse B
            int getVisibleAndIR();                                  //mesure la luminosité du visible et des infrarouges
            int getIROnly();                                        //mesure uniquement la luminosité infrarouge
            float getLux();                                         //convertit les donnée ent lux 
            float readIntegrationTime();                            //calcule le temps d'intégration necessaire pour une mesure correcte
            int readGain();                                         //calcule le gain necessaire pour une mesure correcte
            char readSingleRegister( char A);                       //retourne un mot lu dans le registre d'addresse A
            float obtenirLuminosite();                              //calcule, affiche et retourne la luminosité
            
};





#endif