#include "mbed.h"
SPI deviceM(PB_15, PB_14, PB_13);
DigitalOut ssel (PB_12);
Serial a(USBTX,USBRX);
#define  uint8_t unsigned char
int Tipofig=0;
int vcol;
float Vel=0.3;
int grado=0;
int in,out;
uint8_t dat [8]={0,0,0,0,0,0,0,0};
uint8_t F_t[3]={0b11100000,0b01000000,0};
uint8_t F_s[3]={0b11000000,0b01100000,0};
uint8_t F_c[3]={0b11000000,0b11000000,0};
uint8_t F_l[3]={0b11000000,0b10000000,0b10000000};
uint8_t F_I[3]={0b10000000,0b10000000,0b10000000};
int poscol;
 
void sendSPI(uint8_t d1, uint8_t d2)
{
    deviceM.unlock();
    ssel=0;
    deviceM.write(d1); 
    deviceM.write(d2);  
    ssel=1;
    deviceM.lock(); 
}

void borrar()
{
    for(int i=1;i<=8;i++){
    sendSPI(i,0);}
}   

void printMatrix(uint8_t* vC, uint8_t col)
{
    int i;
    int j=1;
    int h=1;
    for(i=1;i<=8;i++){
        
        if(*(vC+1)==0b00000000 && *(vC)==0b00000000){
                sendSPI(i,*(vC+2)>>col-1); 
                  if(i>2){
                  sendSPI(i-1,0);
                  }   
        }
        else
        {  
          if(*(vC)==0b00000000 && i>=1){
                j=i;
                h=j-1;
                sendSPI(j,*(vC+1)>>col-1);
                sendSPI(h,*(vC+2)>>col-1);
                if(i>2){
                sendSPI(i-2,0);}
           }        
          else {
             if(i>=1){
             j=i-1;
             h=i-2;
             sendSPI(i,*(vC)>>col-1);
             sendSPI(j,*(vC+1)>>col-1);
             sendSPI(h,*(vC+2)>>col-1);
               if(i>2){
               sendSPI(i-3,0);
               }  
             }
           }  
        }
    wait(Vel);
    }
}

void giro(uint8_t *f,uint8_t col,uint8_t gi)
     {  
     if(col>=5){
                col=5;
                }
     uint8_t a[3]={0,0,0};
     int i;
     int j;
         switch(gi){    
         case 0:
         printMatrix(f,col);
         break;
         case 1:
         for(j=0;j<3;j++){
            for(i=0;i<3;i++){
             a[i]=((((*(f+j))<<2-i)&0b10000000)>>j)+a[i];
            }
         }   
         printMatrix(a,col);
         break;
         case 2:
         for(j=0;j<3;j++){
            for(i=0;i<3;i++){
             a[i]=((((*(f+(2-i)))>>2-j)&0b00100000)<<j)+a[i];
            }
            }
         printMatrix(a,col);
         break;
         case 3:
         for(j=0;j<3;j++){
            for(i=0;i<3;i++){
             a[i]=((((*(f+j))>>2-i)&(0b00100000))<<j)+a[i];
            }
          }   
         printMatrix(a,col);
         break;
         default:
         break;
         }     
     }

int main() {
                    a.baud(9600);
                    sendSPI(0x0c,1);
                    sendSPI(0x09,0);
                    sendSPI(0x0A,0x01);
                    sendSPI(0x0F,1);
                    wait (0.5);
                    sendSPI(0x0F,0);
                    wait (0.5);
                    sendSPI(0xB,0x7);
                    borrar();                  
                    while(1){
                        in=a.getc();
                        Tipofig=a.getc();
                        vcol=a.getc();
                        grado=a.getc();
                        out=a.getc();
                        if(in==60 && 1<=Tipofig<=5 && 1<=vcol<=8 && 0<=grado<=3 && out==62){
                          switch(Tipofig)
                          {
                           case 1:
                           giro(F_t,vcol,grado);
                           break;
                           case 2:
                           giro(F_s,vcol,grado);
                           break;
                           case 3:
                           giro(F_c,vcol,grado);
                           break;
                           case 4:
                           giro(F_l,vcol,grado);
                           break;
                           case 5:
                           giro(F_I,vcol,grado);
                           break;
                           default:
                           borrar();
                           break;
                          }
                        }
                        else{
                            borrar();
                            }
                     }
                    
}