/** Control Loco.

Por: Laura Ávila
     Daniela López
     Nicolás Villegas

Este programa interfiere de forma loca la operación de un televisor.
Emite códigos de t.v. con el fin de fastidiar al televidente.

El control utilizado es de marca Panasonic. Se encontró que los códigos IRDA para
esta referencia tienen una longitud de 48 bits. Se modificó el programa "Capturas IRDA"
para ajustarse a esta característica y con base en eso se obtuvieron los códigos.

La emisión es aleatoria para
   1 Mute
   2 On/Off
   3 Vol+
   4 Vol-
   5 Ch+
   6 Ch-
*/

#include "mbed.h"
#include <Timer.h>
#include <math.h>
#include "TextLCD.h"

Timer timer;
DigitalOut led(PTE31);
DigitalOut indic(LED2);
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7

int code[50];
int aleatorio(int a, int b);
void enviar_uno(int duracion);
void enviar_codigo(int n_bits, int *code);

const int n_bits = 48;
const int header_L = 3440;
const int header_H = 1737;

const unsigned ch_up[] = {449,1346,477,477,476,476,476,477,477,476,476,476,476,1346,476,477,477,478,476,475,476,476,477,1347,475,475,475,476,477,475,476,475,476,476,1346,476,1348,1320,476,475,475,476,1345,476,1347,1320,476,1346};
const unsigned ch_down[] = {452,1323,451,452,452,453,452,454,452,451,453,451,453,1323,454,451,452,452,453,452,451,452,452,1322,451,451,453,452,453,452,454,451,1300,451,1322,453,1322,1322,451,451,1322,452,1322,451,1297,1298,450,1323};
const unsigned mute[] = {457,1326,456,457,456,456,456,456,457,458,481,457,458,1326,481,455,456,456,457,457,456,456,457,1326,458,455,456,456,458,456,480,454,458,1327,456,456,1327,1327,455,458,457,1327,481,457,1328,1326,455,1328};
const unsigned power[] = {476,1347,476,477,475,477,475,476,476,476,475,450,476,1347,476,475,476,476,476,478,477,477,475,1346,477,476,477,476,476,476,477,476,1346,477,1346,1347,1346,1347,475,477,1347,476,1324,1347,1346,1325,456,1327};
const unsigned vol_up[] = {452,1322,452,452,452,453,452,451,451,452,452,452,452,1322,452,453,451,452,452,452,452,452,453,1322,451,454,453,453,453,452,452,452,452,453,453,452,453,1323,452,452,454,453,453,454,453,1323,453,1323};
const unsigned vol_down[] = {453,1298,454,452,454,453,454,453,453,453,453,454,453,1324,454,453,454,454,452,454,453,454,454,1323,452,453,452,452,453,453,453,453,1322,454,452,453,452,1322,451,452,1323,454,452,453,452,1324,452,1323};
char* msg;                
                 
int main() {
   
    timer.start();
    lcd.cls();
       
    while (true) {
        
        int numero = aleatorio(0, 57) % 6;  // Se escoge un número aleatorio para seleccionar la acción.
        
        switch (numero) {
            case 0:
                for (int i = 0; i < n_bits; i++) {
                    code[i] = ch_up[i];
                    msg = "ch_up";
                }
                break;
            case 1:
                for (int i = 0; i < n_bits; i++) {
                    code[i] = ch_down[i];
                    msg = "ch_down";
                }
                break;
            case 2:
                for (int i = 0; i < n_bits; i++) {
                    code[i] = mute[i];
                    msg = "mute";
                }
                break;
            case 3:
                for (int i = 0; i < n_bits; i++) {
                    code[i] = power[i];
                    msg = "power";
                }
                break;
            case 4:
                for (int i = 0; i < n_bits; i++) {
                    code[i] = vol_up[i];
                    msg = "vol_up";
                }
                break;
            case 5:
                for (int i = 0; i < n_bits; i++) {
                    code[i] = vol_down[i];
                    msg = "vol_down";
                }
                break;
        }
        
        int minutos = aleatorio(1, 100) % 10; // Un número aleatorio entre 0 y 9 minutos.
        
        for (int m = minutos; m > 0; m--) {   // Se muestra un contador de tiempo descendente que muestra la acción siguiente.
            for (int s = 59; s >= 0; s--) {
                indic = !indic;
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("%s en %2d:%02d", msg, m, s);
                wait(1);
            }
        }
        
        enviar_codigo(n_bits, code);
        
    }
}

void enviar_uno(int duracion) { // Se conmuta rápidamente el led infrarrojo para enviar un 1.

    Timer t;
    t.reset();
    t.start();
    
    while (t.read_us() < duracion) {
        led = 1;
        wait_us(8);
        led = 0;
        wait_us(8);
    } 
}

void descanso(int duracion) { // Se espera con el led infrarrojo apagado.
    wait_us(duracion);
}
                     
void enviar_codigo(int n_bits, int *code) {

    led = 0;
    wait_ms(100);
    enviar_uno(header_L);
    descanso(header_H);
    
    for (int i = 0; i < n_bits; ++i) {
        enviar_uno(400);
        descanso(code[i]);
    }
    enviar_uno(420);
}

int aleatorio(int a, int b) {
    return rint((b - a) * abs(cos((double)timer.read_us())) + a);
} 