#include "mbed.h"
#include "DebouncedIn.h"
#include "stdio.h"
#include "string.h"
#include "GPS.h"
#include "TextLCD.h"

//Salidas digitales
Timer t;
Timer t2;
DigitalOut LedVerde(LED2);
DigitalOut LedRojo(LED1);
DigitalOut LedAzul(LED3);

// Entrada análoga
AnalogIn v(PTB0);
float medi;

Serial GSM(PTE0,PTE1);
Serial pc(USBTX,USBRX);
GPS gps(PTE22, PTE23);
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7
DigitalOut led_alarma(PTA5);
DigitalOut led_carro(PTA4);

char DE1[255];
char DS1[255];
char DE2[255];
char DS2[255];
char buffer[512];
char resp[6];
char tam[2];
char mensaje[100];

//Variables enteras y caracteres
int count;
int i, K, LENOUT1, LENIN1, LENOUT2, LENIN2, C;
int c=0;
char r[]=""; 
char msg[256];
char char1;
int ind;
float med;
char outmed[16], outmedn[16];
int ret = 1;
char tel[15] = {'0', '3', '3', '4', '4', '7', '6', '2', '6', '1'};
bool noM2 = true, noM5 = true, noM3 = true, aviso = false, noOf = true;
char mensajeM2[] = "Saliendo por la porteria del M2. Vehiculo apagado.";
char mensajeM3[] = "Saliendo por la porteria del M3. Vehiculo apagado.";
char mensajeM5[] = "Saliendo por la porteria del M5. Vehiculo apagado.";
char mensajeOficina[255];
char buf[100];
char relle1[] = "0011000A91";
char relle2[] = "0000AA";
float latitud, longitud, frac_long, frac_lat;

// Usando el GPS se obtuvo las coordenadas de la porteria del bloque M2: 6.274062N, 75.592538W.
float distanciaM2(float x, float y) {
    return sqrt(pow((x - 6.274062f), 2) + pow((y + 75.592538f), 2));                                        
}

// Usando el GPS se obtuvo las coordenadas de la porteria del bloque M3: 6.274674N, 75.590680W.
float distanciaM3(float x, float y) {
    return sqrt(pow((x - 6.274674f), 2) + pow((y + 75.590680f), 2));                                        
}

// Usando el GPS se obtuvo las coordenadas de la porteria del bloque M5: 6.275458N, 75.591170W.
float distanciaM5(float x, float y) {
    return sqrt(pow((x - 6.275458f), 2) + pow((y + 75.591170f), 2));
}

float distanciaOficina(float x, float y) { // https://www.google.com.co/maps/search/6.275206,-75.592836/
    return sqrt(pow((x - 6.275206), 2) + pow((y + 75.592836f), 2));
}

// Funcion para enviar un mensaje de alerta:
void alarma(char* msj) {
    strcpy(DE1,msj);        
    LENIN1 = strlen(DE1);
    K = 0;
    C = 0;
    for (i = 0; i < LENIN1; i++){
        DS1[i] = DE1[i + C] >> K | DE1[i + C + 1] << (7 - K);
        if(DS1[i] == 0x00) {LENOUT1 = i;}   
        K++;
        if (K == 7) {K = 0; C++;} // se chequea que ya se acabaron los bits en un ciclo de conversion.
    }
    
    // Concatenación del mensaje en formato PDU y envío del mismo.
    ind = 14 + LENOUT1 - 1;
    
    GSM.printf("AT+CMGS=%d\r\n",ind);
    pc.printf("AT+CMGS=%d\r\n",ind);
    pc.printf(relle1);
    GSM.printf(relle1);
    
    for (i=0 ;i<=9; i++)  {
        pc.printf("%c",tel[i]);
        GSM.printf("%c",tel[i]);
    }
    
    pc.printf(relle2);
    GSM.printf(relle2);
    pc.printf("%2X", LENIN1);
    GSM.printf("%2X", LENIN1);
     
    for (i = 0; i < LENOUT1; i++){
        pc.printf("%02X", DS1[i]&0x000000FF);
        GSM.printf("%02X", DS1[i]&0x000000FF);
    }
    wait(1);
    GSM.putc((char)0x1A); // Ctrl - Z.
    GSM.scanf("%s",buf); // Estado del mensaje (Envió o Error).
    pc.printf(">%s\n",buf);
    pc.printf("\n");
}

// Leer el buffer:
int readBuffer(char *buffer,int count){
    int i = 0; 
    t.start();
    while(true) {
        while (GSM.readable()) {
            char c = GSM.getc();
            buffer[i++] = c;
            if(i > count + 1)break;
        }
        if(i > count)break;
        if(t.read() > 3) {
            t.stop();
            t.reset();
            break;
        }
    }
    wait(0.5);
    while(GSM.readable())
        char c = GSM.getc();
    return 0;
}

void sendCmd(char *cmd){
    GSM.puts(cmd);
}

int waitForResp(char *resp, int timeout){
    int len = strlen(resp);
    int sum = 0;
    t.start();
 
    while(true) {
        if(GSM.readable()) {
            char c = GSM.getc();
            sum = (c == resp[sum]) ? sum + 1 : 0;
            if(sum == len)break;
        }
        if(t.read() > timeout) {
            t.stop();
            t.reset();
            return -1;
        }
    }
    t.stop();
    t.reset();
    while(GSM.readable()) {
        char c = GSM.getc();
    }
    return 0;
}

int sendCmdAndWaitForResp(char *cmd, char *resp, int timeout){
    sendCmd(cmd);
    return waitForResp(resp,timeout);
}
 
int init() {
    if (0 != sendCmdAndWaitForResp("AT\r\n", "OK", 3))
        return -1;
    if (0 != sendCmdAndWaitForResp("AT+CNMI=1,1\r\n", "OK", 3))
        return -1;
    if (0 != sendCmdAndWaitForResp("AT+CMGF=0\r\n", "OK", 3))
        return -1;
    if (0 != sendCmdAndWaitForResp("AT+CBST=7,0,1\r\n", "OK", 3))
        return -1;
    if (0 != sendCmdAndWaitForResp("ATE\r\n", "OK", 3))
        return -1;
    LedVerde=0;
    return 0;
}

int recibe_ok() {
    GSM.printf("AT+CMGS=27\n\r");
    pc.printf("AT+CMGS=27\n\r");
    wait_ms(100);
    GSM.printf("0011000A91%s0000AA10CDB27B1E569741F2F2382D4E93DF",tel);
    pc.printf("0011000A91%s0000AA10CDB27B1E569741F2F2382D4E93DF",tel);
    wait_ms(100);
    GSM.putc((char)0x1A);
    return 0;
}

int main() {
    
    t2.start();
    GSM.baud(9600);
    GSM.format(8, Serial::None, 1);     
    LedVerde = 1;
    LedRojo = 1; 
    LedAzul = 1;
    led_carro = 1;
    led_alarma = 0;
    aviso = false;
    
inicio1:   
    
    // Configurando Modem...
    ret = init();
    lcd.locate(0,0);
    lcd.printf("Configurando\nModem...");
    wait(2);
    
    if (ret == 0) {
        LedRojo = 1;
        LedVerde = 0; // Apagar LED Verde para confirmar la comunicación con el módem.
        pc.printf("Hecho!\n");
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Hecho!");
        wait(1);
    }
    else {
        wait(1);
        goto inicio1;    
    }
    
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("   Alarma de   \n   seguridad.   ");
    wait(5);
    
    while(true) {
        
        // A continuacion se verifica si esta entrando una llamada.
        // Si es el caso, se apaga el carro.
        
        if (GSM.readable()) {
            
            readBuffer(buffer, 110);
            
            for(i=0; i < 5; i++)
                resp[i] = buffer[i];
                
            pc.printf(resp);
                
            if (strcmp("\r\nRIN", resp) == 0) {
                lcd.cls();
                led_carro = 0;
                lcd.locate(0,0);
                lcd.printf("Llamada!!!\nApagando carro..");
                pc.printf("Llamada!!!\n\r");
                wait(5);
            }
        }
        
        char dir1[32];
        char dir2[32];
        char dirc[255];
        
        // Cada 3 segundos se lee el GPS para actualizar la posicion y enviar mensaje de alerta de ser necesario.
        if (int(t2.read()) % 3 == 0) {
            gps.sample();
            latitud = gps.latitude;
            longitud = gps.longitude;
            
            if (distanciaM5(latitud, longitud) <= 1000.00015f && !aviso) {
                aviso = true;
                led_alarma = 1;
                noM5 = false;
                sprintf(dir1, "%2.6f", latitud);
                sprintf(dir2, "%2.6f", longitud);
                strcpy(dirc, "https://www.google.com.co/maps/search/");
                strcat(dirc, dir1);
                strcat(dirc, ",");
                strcat(dirc, dir2);
                alarma(dirc);
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("M5: Enviando\nalerta...");
            }
            else if (distanciaM5(latitud, longitud) > 0.00015f && aviso)
                noM5 = true;
            
            if (distanciaM2(latitud, longitud) <= 0.00015f && !aviso) {
                aviso = true;
                led_alarma = 1;
                noM2 = false;
                sprintf(dir1, "%2.6f", latitud);
                sprintf(dir2, "%2.6f", longitud);
                strcpy(dirc, "https://www.google.com.co/maps/search/");
                strcat(dirc, dir1);
                strcat(dirc, ",");
                strcat(dirc, dir2);
                alarma(dirc);
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("M2: Enviando\nalerta...");
            }
            else if (distanciaM2(latitud, longitud) > 0.00015f && aviso)
                noM2 = true;
            
            if (distanciaM3(latitud, longitud) <= 0.00015f && !aviso) {
                aviso = true;
                led_alarma = 1;
                noM3 = false;
                sprintf(dir1, "%2.6f", latitud);
                sprintf(dir2, "%2.6f", longitud);
                strcpy(dirc, "https://www.google.com.co/maps/search/");
                strcat(dirc, dir1);
                strcat(dirc, ",");
                strcat(dirc, dir2);
                alarma(dirc);
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("M3: Enviando\nalerta...");
            }
            else if (distanciaM3(latitud, longitud) > 0.00015f && aviso)
                noM3 = true;
            
            if (noM2 && noM5 && noM3 && noOf && !aviso) {
                led_carro = 1;
                led_alarma = 0;
            }
            
            // Si la distancia a la oficina es pequeña entonces envia la direccion de google Maps!!:
            if (distanciaOficina(latitud, longitud) <= 0.00015f && !aviso) {
                led_alarma = 1;
                aviso = true;
                noOf = false;
                sprintf(dir1, "%2.6f", latitud);
                sprintf(dir2, "%2.6f", longitud);
                strcpy(dirc, "https://www.google.com.co/maps/search/");
                strcat(dirc, dir1);
                strcat(dirc, ",");
                strcat(dirc, dir2);
                pc.printf("%s\n", dirc);
                alarma(dirc);
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("M3: Enviando\nalerta...");
                wait(5);
            }
            else if (distanciaM3(latitud, longitud) > 0.00015f && aviso)
                noM3 = true;
            
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf(" Lat: %02.6f\n Lon: %02.6f", latitud, longitud);
            
        }
        
    }
}