#include "GPS.h"

GPS::GPS(PinName tx, PinName rx) : _gps(tx, rx) {
    _gps.baud(9600);    
    longitude = 0.0;
    latitude = 0.0;        
}

int GPS::sample() {
    float time;
    float deg_lat, deg_lon, min_lat, min_lon;
    char ns, ew;
    int lock;

    while(true) {        
        getline();
        if(sscanf(msg, "GPGGA,%f,%f,%c,%f,%c,%d", &time, &latitude, &ns, &longitude, &ew, &lock) >= 1) { 
            if(!lock) {
                longitude = 0.0;
                latitude = 0.0;        
                return 0;
            } 
            else {
                if(ns == 'S') {     latitude  *= -1.0; }
                if(ew == 'W') {     longitude *= -1.0; }
                latitude = (latitude / 100.0f);   
                longitude = (longitude / 100.0f);
                deg_lat = trunc(latitude);
                deg_lon = trunc(longitude);
                min_lat = (latitude - deg_lat);
                min_lon = (longitude - deg_lon);
                latitude = deg_lat + min_lat / 60.0f * 100.0f;
                longitude = deg_lon + min_lon / 60.0f * 100.0f;
                return 1;
            }
        }
    }
}

float GPS::trunc(float v) {
    if(v < 0.0) {
        v*= -1.0;
        v = floor(v);
        v*=-1.0;
    }
    else {
        v = floor(v);
    }
    return v;
}

void GPS::getline() {
    while(_gps.getc() != '$');
    for(int i = 0; i < 256; i++) {
        msg[i] = _gps.getc();
        if(msg[i] == '\r') {
            msg[i] = 0;
            return;
        }
    }
    error("Overflowed message limit");
}
