 /* Copyright (c) 2012 - 2013 AUTEUR
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 
 /*
 * Description : Cette classe contient les fonctionnalités d'un buffer de trame.
 * Input
 * Output
 */
 
 
 #ifndef BUFFER_TRAME_H
 #define BUFFER_TRAME_H
 
 #include "mbos.h"
 
 #define default_size 50
 
 typedef struct {
    char systemIdentifier;
    char moduleIdentifier;
    char messageIdentifier;
    char data [12];
 }frame;
 
 class C_FrameBuffer {
 
 private :
    /* ATTRIBUTS */
    frame * m_frameBuffer;
    unsigned int m_currentReadIndex;
    unsigned int m_currentWriteIndex;
    unsigned int m_numberMessage;
    unsigned int m_maxSize;
    
 public :
    /* CONSTRUCTEUR(S) */
    C_FrameBuffer();
    C_FrameBuffer(unsigned int size);
    
    /* DESTRUCTEUR */
    ~C_FrameBuffer();
    
    /* Propriétés */
    void frameBuffer(frame newFrame);
    frame frameBuffer(void);
    unsigned int maxSize(void);
    unsigned int currentReadIndex(void);
    unsigned int currentWriteIndex(void);
    unsigned int numberMessage(void);
 };
 
 #endif