 /* Copyright (c) 2012 - 2013 AUTHEUR
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 
 /*
 * Description
 * Input
 * Output
 */
 
 #ifndef MODULE_MOUVEMENT_H
 #define MODULE_MOUVEMENT_H
 
 #include "mbos.h"
 #include "ITG3200.h"
 #include "Motor.h"
 
 #define SDA p9
 #define SCL p10
 #define PWM p21
 #define FDW p22
 #define REV p23
 
/* Point d'entrée de la tache du Module Mouvement */
void ModuleMouvement_Task(void);
 
 class ModuleMouvement
 {
 private :
    /* ATTRIBUTS */

    ITG3200 *m_gyro;
    Motor *m_motor;
 
 public :
    /* CONSTRUCTEUR(S) */
    ModuleMouvement();
    int m_gyroX;
    int m_gyroY;
    int m_gyroZ;
    
    /* DESTRUCTEUR */
    ~ModuleMouvement();
    
    /* METHODES */
    void allumMotor();
    void eteindMotor();
    void getGyroValue();
    void creerTrame(char *envoi);
    void traiteCommande();
 
    /* FONCTIONS */
 
 };
 
 #endif