 /* Copyright (c) 2012 - 2013 AUTHEUR
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 
 /*
 * Description : Cette classe contient les fonctionnalités du module communication.
                 Le module communication gère la communication entre les modules présents sur le drône et le PC.
 * Input
 * Output
 */
 
 #include "Module_Communication.h"
 #include "os.h"
 #define TAILLE_BUFFER 6
 
 // Pointeur sur la classe systeme d'exploitation instancié dans le main
 extern mbos os;
 extern unsigned int COMMANDE_TRAJECTOIRE;
 extern bool STOP;
 extern bool EN_MOUVEMENT;
 extern position COORDONNEE_DRONE;
 extern Serial pc;
 
 char buffer[TAILLE_BUFFER];
 char reception[TAILLE_BUFFER];
 //extern char *envoi;
 char envoi[15];
 int pos;
 
 
xbee *com_xbee = new xbee(PINTX, PINRX, PINRES);
 
 /* CONSRTRUCTEUR(S) */
 C_ModuleCommunication::C_ModuleCommunication()
 {
    m_xbee = new xbee(p9, p10, p11);
    m_trameRxBuffer = C_FrameBuffer();
    m_trameTxBuffer = C_FrameBuffer();
    m_charRxBuffer = new char[17];
    m_charTxBuffer = new char[17];
 }
 
 /* DESTRUCTEUR */
 C_ModuleCommunication::~C_ModuleCommunication()
 {
    delete [] m_charRxBuffer;
    delete [] m_charTxBuffer;
    delete m_xbee;
 }
 void flushRx(void)
 {
    for(int i = 0 ; i < TAILLE_BUFFER ; i++){
        buffer[i] = '\0';
    }
 }
 void addToReception(void)
 {
    for(int i = pos ; i < TAILLE_BUFFER ; i++){
        reception[i] = buffer[i-pos];
    }
    pos += strlen(buffer);
 }
 
 
 /* Point d'entrée de la tache Module Video */
 
 void moduleCommunicationEnvoi(void)
 {
    while(1){
        os.WaitEvent(COMMUNICATION_EVENT);
        
        if(com_xbee->SendData(envoi)){
            pc.printf("send %s\n", envoi);
        }
        else{
            pc.printf("envoi non envoye\n");
        }
    }
 }
 
 void moduleCommunicationReception(void)
 {
     pos = 0;
     os.SetTimer(TIMER_COM_ID, TIMER_COM_PERIOD, TIMER_COM_PERIOD);
     while(1){
        os.WaitEvent(TIMER_EVENT);
        if(os.GetEvent() & TIMER_EVENT){
            com_xbee->RecieveData(buffer, 1);
            pc.printf("recu : %s\n", buffer);
            /*if(strlen(buffer) + pos < TAILLE_BUFFER){ //trame non complète
                addToReception();
                pc.printf("buffer : %s\n", buffer);
                flushRx();
            }
            else{
                addToReception();
                pos = 0;
                pc.printf("recu : %s\n", reception);
                //traite reception
            }*/
            
            //flushRx();
        }
    }
 }
 
 char *getEnvoi(){
    return envoi;
 }
 
 void C_ModuleCommunication::moduleCommunicationTask(void)
 {

 
    while(1){
    // Code
    }
 }
 
 void C_ModuleCommunication::envoiDeTrame(void)
 {
    frame newFrame = m_trameTxBuffer.frameBuffer();
    m_charTxBuffer[0] = 0x02;
    m_charTxBuffer[1] = newFrame.systemIdentifier;
    m_charTxBuffer[2] = newFrame.moduleIdentifier;
    m_charTxBuffer[3] = newFrame.messageIdentifier;
    m_charTxBuffer[16] = 0x03;
    
    for(int i = 0; i < 12; i++) {
        m_charTxBuffer[i+4] = newFrame.data[i];
    }
    
    m_xbee->SendData(m_charTxBuffer);
 }
 
 void C_ModuleCommunication::receptionDeTrame(void)
 {
    Serial pc(USBTX, USBRX);
    m_xbee->RecieveData(m_charRxBuffer, 0);
    pc.printf("You said:%s \n",m_charRxBuffer);
    
    
    frame newFrame;
    newFrame.systemIdentifier = m_charRxBuffer[1];
    newFrame.moduleIdentifier = m_charRxBuffer[2];
    newFrame.messageIdentifier = m_charRxBuffer[3];
    
    for(int i = 0; i < 12; i++) {
        newFrame.data[i] = m_charRxBuffer[i+4];
    }
    
    m_trameRxBuffer.frameBuffer(newFrame);
 }
 
 void C_ModuleCommunication::traitementTrame(void)
 {
    if(m_trameRxBuffer.numberMessage() <= 0) return;
    
    frame newFrame = m_trameRxBuffer.frameBuffer();
    
    switch(newFrame.moduleIdentifier) {
        case 0x31 : consigneModuleTrajectoire(newFrame);
                    break;
        case 0x32 : consigneModuleVideo(newFrame);
                    break;
                    
        default :  creerTrameSpeciale(0x99);
                   break;
                    
    }
 }

void C_ModuleCommunication::consigneModuleTrajectoire(frame newFrame)
{
    switch(newFrame.messageIdentifier) {
        case 0x11 : COMMANDE_TRAJECTOIRE = newFrame.data[0];
                    EN_MOUVEMENT = true;
                    while(EN_MOUVEMENT != false);
                    creerTrameModuleTrajectoire(0x12);
                    break;
        case 0x13 : STOP = true;
                    EN_MOUVEMENT = true;
                    while(EN_MOUVEMENT != false);
                    creerTrameModuleTrajectoire(0x14);
                    break;
        case 0x15 : creerTrameModuleTrajectoire(0x16);
                    break;
                                    
        default : creerTrameSpeciale(0x99);
                  break; 
    }
}

void C_ModuleCommunication::creerTrameModuleTrajectoire(unsigned char idMessage)
{
    frame newFrame;
    newFrame.moduleIdentifier = 0x31;
    
    switch(idMessage) {
        case 0x12 : newFrame.messageIdentifier = 0x12;
                    break;
        case 0x14 : newFrame.messageIdentifier = 0x14;
                    break;
        case 0x16 : newFrame.messageIdentifier = 0x16;
                    union conversionCharFloat conv1;
                    conv1.f = COORDONNEE_DRONE.x;
                    newFrame.data[0] = conv1.ch[0];
                    newFrame.data[1] = conv1.ch[1];
                    newFrame.data[2] = conv1.ch[2];
                    newFrame.data[3] = conv1.ch[3];
                    conv1.f = 0;
                    conv1.f = COORDONNEE_DRONE.y;
                    newFrame.data[4] = conv1.ch[0];
                    newFrame.data[5] = conv1.ch[1];
                    newFrame.data[6] = conv1.ch[2];
                    newFrame.data[7] = conv1.ch[3];
                    conv1.f = 0;
                    conv1.f = COORDONNEE_DRONE.z;
                    newFrame.data[8] = conv1.ch[0];
                    newFrame.data[9] = conv1.ch[1];
                    newFrame.data[10] = conv1.ch[2];
                    newFrame.data[11] = conv1.ch[3];
                    break;
    }
    
    m_trameTxBuffer.frameBuffer(newFrame);
}

void C_ModuleCommunication::creerTrameSpeciale(unsigned char idMessage) {
    frame newFrame;
    
    switch(idMessage) {
        case 0x00 : newFrame.moduleIdentifier = 0x00;
                    newFrame.messageIdentifier = 0x00;
                    break;
        case 0x99 : newFrame.moduleIdentifier = 0x99;
                    newFrame.messageIdentifier = 0x99;
                    break;
    }
    m_trameTxBuffer.frameBuffer(newFrame);
}

void C_ModuleCommunication::consigneModuleVideo(frame newFrame)
{
}