#ifndef MAVLINK_API_H
#define MAVLINK_API_H

#include "mbed.h"
#include "MAVlink/include/common/common.h"

#define DEBUG 1

class mavLink_API
{
private:
    Ticker heartBeatTicker;
    mavlink_system_t mavlink_system;
    mavlink_status_t mavlink_status;

    mavlink_message_t send_msg;
    mavlink_message_t received_msg;
    
public:    

    bool messageReadyToBeSent;
    uint8_t *buf;
    uint16_t len;
    
    mavLink_API(float heartbeat_freq);
    ~mavLink_API();
    
    int getMessage(char received_char);
    int handleMessage();
    int createMessage(int messageID, void* data);
    void sendHeartBeat();
#if DEBUG
    void printMavLinkMessage(mavlink_message_t message);
#endif
    
};

#endif