#include "MAVLink_API.h"

#if DEBUG
Serial debug(USBTX, USBRX);
#endif

mavLink_API::mavLink_API(float heartbeat_freq){
    mavlink_system.sysid = 20;                   ///< ID 20 for this airplane
//mavlink_system.compid = MAV_COMP_ID_IMU;     ///< The component sending the message is the IMU, it could be also a Linux process
    mavlink_system.compid = MAV_COMP_ID_IMU;
    mavlink_system.type = MAV_QUADROTOR;
    
    buf = new uint8_t[MAVLINK_MAX_PACKET_LEN];
    messageReadyToBeSent = false;
    heartBeatTicker.attach(this, &mavLink_API::sendHeartBeat, heartbeat_freq);
#if DEBUG
    debug.printf("Object MAVLinK_API instanciated\n");
#endif
}

mavLink_API::~mavLink_API(){
    
}

void mavLink_API::sendHeartBeat()
{
    
#if DEBUG
    debug.printf("Send heartBeat\n");
#endif
    uint8_t system_type = MAV_QUADROTOR;
    uint8_t autopilot_type = MAV_AUTOPILOT_GENERIC;
 
    uint8_t system_mode = MAV_MODE_READY; ///< Booting up
    uint32_t custom_mode = 0;                 ///< Custom mode, can be defined by user/adopter
    uint8_t system_state = MAV_STATE_STANDBY; ///< System ready for flight
 
// Initialize the required buffers
    mavlink_message_t msg;
 
// Pack the message
    mavlink_msg_heartbeat_pack(mavlink_system.sysid, mavlink_system.compid, &msg, system_type, autopilot_type, system_mode, custom_mode, system_state);
 
// Copy the message to the send buffer
    len = mavlink_msg_to_send_buffer(buf, &msg);
    messageReadyToBeSent = true;
}


int mavLink_API::getMessage(char received_char){
#if DEBUG
    //debug.printf("%X ", received_char);
#endif
    
    if(mavlink_parse_char(MAVLINK_COMM_0, received_char, &received_msg, &mavlink_status)){
        //now handle the message received
        
#if DEBUG
        //debug.printf("\n");
        debug.printf("Received MavLink message :\n");
        printMavLinkMessage(received_msg);
#endif
        switch(received_msg.msgid)
        {
            case MAVLINK_MSG_ID_HEARTBEAT:
#if DEBUG
            debug.printf("received heartbeat\n");
#endif
            break;
            case MAVLINK_MSG_ID_COMMAND:
#if DEBUG
            debug.printf("received command\n");
#endif
            break;
            case MAVLINK_MSG_ID_SET_MODE:
#if DEBUG
            debug.printf("received set mode\n");
            //target_system   uint8_t The system setting the mode
            //base_mode   uint8_t The new base mode
            //custom_mode
#endif
            break;
            case MAVLINK_MSG_ID_PARAM_REQUEST_LIST:
#if DEBUG
            debug.printf("received param request list\n");
#endif
            break;
            default:
#if DEBUG

#endif
            break;
         }
        
    }
    else return 0;
    return 1;
}
int mavLink_API::handleMessage()
{
    return 1;
}

#if DEBUG
void mavLink_API::printMavLinkMessage(mavlink_message_t message)
{
    debug.printf("Len :%d\n", message.len);     ///< Length of payload
    debug.printf("Seq :%d\n", message.seq);     ///< Sequence of packet
    debug.printf("Sysid :%d\n", message.sysid);   ///< ID of message sender system/aircraft
    debug.printf("Compid :%d\n", message.compid);  ///< ID of the message sender component
    debug.printf("MsgId :%d\n", message.msgid);   ///< ID of message in payload
    for(int i = 0 ; i < message.len ; i++){
        debug.printf("%X ", message.payload[i]);
    }
    debug.printf("\n");
    debug.printf("CK_a :%d\n", message.ck_a);    ///< Checksum high byte
    debug.printf("CK_b :%d\n", message.ck_b);    ///< Checksum low byte
}
#endif

int createMessage(int messageID, void* data){
    return 1;
}