 /* Copyright (c) 2012 - 2013 AUTHEUR
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 
 /*
 * Description
 * Input
 * Output
 */
 
 #include "Module_Mouvement.h"
 #include "Module_Communication.h"
 #include "os.h"
 
 // Pointeur sur la classe systeme d'exploitation instancié dans le main
 extern mbos os;
 

DigitalOut led1(LED1);
extern Serial pc;
 
 /* CONSRTRUCTEUR(S) */
 ModuleMouvement::ModuleMouvement()
 {
    m_gyroX = 0;
    m_gyroY = 0;
    m_gyroZ = 0;
    m_gyro = new ITG3200(SDA, SCL);
    m_motor = new Motor(PWM, FDW, REV);
 }
 
 /* DESTRUCTEUR */
 ModuleMouvement::~ModuleMouvement()
 {
    delete m_gyro;
    delete m_motor;
 }
 
 /* Point d'entrée de la tache Module Mouvement */
 void ModuleMouvement_Task(void)
 {
    ModuleMouvement *mouv = new ModuleMouvement();
    os.SetTimer(TIMER_MOUV_ID, TIMER_MOUV_PERIOD, TIMER_MOUV_PERIOD);
    while(1){
        os.WaitEvent(TIMER_EVENT | COMMUNICATION_EVENT);
        if(os.GetEvent() & TIMER_EVENT){
            //send gyro information
            led1 = 1;
            mouv->getGyroValue();
            pc.printf("Gyroscope [x : %d] [y : %d] [z : %d]\n", mouv->m_gyroX, mouv->m_gyroY, mouv->m_gyroZ);
            mouv->creerTrame(getEnvoi());
            pc.printf("trame : %s\n", getEnvoi());
            os.SetEvent(COMMUNICATION_EVENT, TASK_ENVOI);
            led1 = 0;
            
        }
        if(os.GetEvent() & COMMUNICATION_EVENT){
            //traite commande
            pc.printf("mouv receive command\n");
            //mouv->traiteCommande();
        }
    }
 }
 
 void ModuleMouvement::getGyroValue(){
    m_gyroX = m_gyro->getGyroX();
    m_gyroY = m_gyro->getGyroY();
    m_gyroZ = m_gyro->getGyroZ();
 }
 
void ModuleMouvement::allumMotor(){
    for(float i = 0.0 ; i < 0.90 ; i += 0.05){
        m_motor->speed(i);
    }
}
void ModuleMouvement::eteindMotor(){
    for(float i = 0.90 ; i >= 0.0 ; i -= 0.05){
        m_motor->speed(i);
    }
}
 
 void ModuleMouvement::creerTrame(char *envoi){
    //creer un trame envoi pour la tache Com
    envoi[0] = 'G';
    memcpy(&envoi[1], &m_gyroX, 4);
    memcpy(&envoi[5], &m_gyroY, 4);
    memcpy(&envoi[9], &m_gyroZ, 4);
    envoi[13] = 'F';
    envoi[14] = '\0';
    
 }
 
 void ModuleMouvement::traiteCommande(){
    //allum // eteind moteur
 }