 /* Copyright (c) 2012 - 2013 AUTEUR
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 
 /*
 * Description : Cette classe contient les fonctionnalités d'un buffer de trame.
 * Input
 * Output
 */
 
 #include "Buffer_Trame.h"
 
 /* CONSRTRUCTEUR(S) */
 C_FrameBuffer::C_FrameBuffer()
 {
    m_frameBuffer = new frame[default_size];
    m_maxSize = default_size;
    m_currentReadIndex = 0;
    m_currentWriteIndex = 0;
    m_numberMessage = 0;
 }
 
 C_FrameBuffer::C_FrameBuffer(unsigned int size)
 {
    m_maxSize = size;
    m_frameBuffer = new frame[m_maxSize];
    m_currentReadIndex = 0;
    m_currentWriteIndex = 0;
    m_numberMessage = 0;
 }
 
 /* DESTRUCTEUR */
 C_FrameBuffer::~C_FrameBuffer()
 {
    delete [] m_frameBuffer;
    m_maxSize = 0;
    m_currentReadIndex = 0;
    m_currentWriteIndex = 0;
    m_numberMessage = 0;
 }
 
 /* Propriétés */
 void C_FrameBuffer::frameBuffer(frame newFrame)
 {
    m_frameBuffer[m_currentWriteIndex] = newFrame;
    m_currentWriteIndex++;
    m_numberMessage++;
    
    if(m_currentWriteIndex >= m_maxSize) m_currentWriteIndex = 0;
 }
 
 frame C_FrameBuffer::frameBuffer(void)
 {
    frame newFrame = m_frameBuffer[m_currentReadIndex];
    m_currentReadIndex++;
    m_numberMessage--;
    
    if(m_currentReadIndex >= m_maxSize) m_currentReadIndex = 0;
    
    return newFrame;
 }

 unsigned int C_FrameBuffer::maxSize(void)
 {
    return m_maxSize;
 }
 
 unsigned int C_FrameBuffer::currentReadIndex(void)
 {
    return m_currentReadIndex;
 }
 
 unsigned int C_FrameBuffer::currentWriteIndex(void)
 {
    return m_currentWriteIndex;
 }
 
 unsigned int C_FrameBuffer::numberMessage(void)
 {
    return m_numberMessage;
 }