 /* Copyright (c) 2012 - 2013 Yang Shi
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 
 /*
 * Description : Cette classe contient les fonctionnalités du module communication.
                 Le module communication gère la communication entre les modules présents sur le drône et le PC.
 * Input : 
 * Output
 */
 
 #ifndef MODULE_COMMUNICATION_H
 #define MODULE_COMMUNICATION_H
 
 #include "mbos.h"
 #include "xbee.h"
 #include "Buffer_Trame.h"
 #include "Service.h"
 
 #define PINTX p13
 #define PINRX p14
 #define PINRES p15
 
 
  void moduleCommunicationReception(void);
  void moduleCommunicationEnvoi(void);
  char *getEnvoi();
 
 class C_ModuleCommunication
 {
 private :
    /* ATTRIBUTS */
    xbee * m_xbee;
    C_FrameBuffer m_trameRxBuffer;
    C_FrameBuffer m_trameTxBuffer;
    char * m_charRxBuffer;
    char * m_charTxBuffer;
 
 public :
    /* CONSTRUCTEUR(S) */
    C_ModuleCommunication();
    
    /* DESTRUCTEUR */
    ~C_ModuleCommunication();
    
    /* METHODES */
    void moduleCommunicationTask(void);
    void traitementTrame(void);
    void envoiDeTrame(void);
    void receptionDeTrame(void);
    void creerTrameModuleTrajectoire(unsigned char idMessage);
    void creerTrameSpeciale(unsigned char idMessage);
    void consigneModuleTrajectoire(frame newFrame);
    void consigneModuleVideo(frame newFrame);
 
    /* FONCTIONS */
 
 };
 
 #endif