#include <mbed.h>

/* One enable, forward or backwards, controlling both sides
4 PWM lines, two for each side, one controlling forward speed and one for backward speed for EACH side
driving sequence is pwm off, enable toggle, pwm on */

// motor "enable"
//DigitalOut motorEnableLeft(PTC12); // right motor "enable" (1 = forward, 0 = reverse)
//DigitalOut motorEnableRight(PTA13);


// motor PWM controls
// left motors forward speed control (blue wire) -> PTA5
// right motors forward speed control (green wire) -> PTA4
// left motors backward speed control (yellow wire) -> PTD4
// right motors backward speed control (white wire) -> PTA12

//Left Enable (... wire) -> PTC12
//Right Enable (... wire) -> PTA13

// In order to stop, PWM duty cycle must be = 0
// Enable controls direction wheels spin'


typedef struct PwmDir{
    //PwmDir contains two PWM, on for the left motor one for the right motor
    DigitalOut motorEnable;
    PwmOut motorBw;
    PwmOut motorFw;
    
    //constructor, when create a struct, need to specify the pin it will take.
    //will need to set the pwm value outisde the struct
    PwmDir(PinName pin1, PinName pin2, PinName pin3) : motorEnable(pin1), motorBw(pin2), motorFw(pin3) {};
    
    }PwmDir;

//initialize the pwms and their pin numbers here, 1 enable 2 PwmBw 3 PwmFw
    PwmDir pwmLeft(PTC12,PTD4,PTA5);
    PwmDir pwmRight(PTA13,PTA12,PTA4);
    

PwmOut* SetDirection(bool direction,bool pwmSelect){
    /*set direction of one of the sides depending on pwmSelect
    direction : 0 go forward  ,1 go backwards
    pwmSelect : 0 left motors ,1 right motors */    
    
    if(!pwmSelect){
    //modify the left motor's direction
    //set every pwm to 0
    pwmLeft.motorBw.write(0);
    pwmLeft.motorFw.write(0);
    
    wait(0.1);
        
        if(!direction){
            pwmLeft.motorEnable = false;
            return &(pwmLeft.motorFw);
            }
        else{
            pwmLeft.motorEnable = true;
            return &(pwmLeft.motorBw);
            }  
    }else{
    //modify right motors direction
    //set every pwm to 0
    pwmRight.motorBw.write(0);
    pwmRight.motorFw.write(0);
    
    wait(0.1);
    
        if(!direction){
            pwmRight.motorEnable = false;
            return &(pwmRight.motorFw);
            }
        else{
            pwmRight.motorEnable = true;
            return &(pwmRight.motorBw);
            }
        }
    }

void SetSpeed(float speed, PwmOut *pwmLeftPtr, PwmOut *pwmRightPtr) {
    // set speed of either forward or backward PWMs
    // set both wheels to same speed
    // NOTE: set enable BEFORE calling function
    // speed: speed to be set
    // mRight & mLeft: pass PwmOut names of relevant Right and Left motor controls
    
    if(speed<=1.0){
        pwmLeftPtr->write(speed);
        pwmRightPtr->write(speed);
    }
}

void SetSpeed(float speed, PwmOut *pwmDirPtr) {
    // set speed of passed the pointer to PwmOut  
    // sets speed to only right or left depending on which pointer is passed
    
    if(speed<=1.0){
        (*pwmDirPtr).write(speed);
    }
}

int main() {
    //pointers which point to either PWM forward or backwards of left and right
    PwmOut *pwmLeftPtr;
    PwmOut *pwmRightPtr;
    
    //Assign pwm forward to the pointers
    pwmLeftPtr = &(pwmLeft.motorFw);
    pwmRightPtr = &(pwmRight.motorFw);
    
    //give a period of 1khz to every pwm
    pwmLeft.motorBw.period_ms(1);
    pwmLeft.motorFw.period_ms(1);
    pwmRight.motorBw.period_ms(1);
    pwmRight.motorFw.period_ms(1);
    
    //duty cycle of 0
    pwmLeft.motorBw.write(0);
    pwmLeft.motorFw.write(0);
    pwmRight.motorBw.write(0);
    pwmRight.motorFw.write(0);
    
    
    float speed = 0.2;
    //float angle = 1.0;
    bool directionLeft = 0;
    bool directionRight = 0;

    //first set direction left and right to forward 
    pwmLeftPtr = SetDirection(directionLeft, 0);
    pwmRightPtr = SetDirection(directionRight, 1);
    
    while(1){
        //both forward
        directionLeft = 0;
        directionRight = 0;
        
        pwmLeftPtr = SetDirection(directionLeft, 0);
        pwmRightPtr = SetDirection(directionRight, 1);
        
        SetSpeed(speed, pwmLeftPtr, pwmRightPtr);
        
        wait(1);
        
        //left forward right backwards
        directionLeft = 0;
        directionRight = 1;
        
        pwmLeftPtr = SetDirection(directionLeft, 0);
        pwmRightPtr = SetDirection(directionRight, 1);
        
        SetSpeed(speed, pwmLeftPtr);
        SetSpeed(speed, pwmRightPtr);
        
        wait(1);
        
        //left backwards right backwards
        directionLeft = 1;
        directionRight = 0;
        
        pwmLeftPtr = SetDirection(directionLeft, 0);
        pwmRightPtr = SetDirection(directionRight, 1);
        
        SetSpeed(speed, pwmLeftPtr);
        SetSpeed(speed, pwmRightPtr);
        
        wait(1);
         
         //both forward
        directionLeft = 1;
        directionRight = 1;
        
        pwmLeftPtr = SetDirection(directionLeft, 0);
        pwmRightPtr = SetDirection(directionRight, 1);
        
        SetSpeed(speed, pwmLeftPtr, pwmRightPtr);
        
        wait(1);
        
    }
}