#ifndef RobotControl_H
#define RobotControl_H

#include <mbed.h>

//RobotControl is used to control the direction and speed of the robot
//attributes : the pinouts of the enable and pwm forward and backwards
//methods : SetSpeed and SetDirection to set speed and set direction

class RobotControl
{
private:
    
    DigitalOut m_motorEnable;
    PwmOut m_motorBw;
    PwmOut m_motorFw;
    PwmOut* m_pwmPtr;
    
    bool m_prevDir;
    
    
public:
    
    bool m_dir;
    float m_speed;
    
    RobotControl(PinName pin1, PinName pin2, PinName pin3); //initializes the pins, direction and speed
    
    void SetDirection(bool dir);        //sets direction of robot, forward or backwards
    void SetSpeed(float speed);         //sets speed of robot regardless of direction
    
};




#endif