#include "L298_H.h"
#include <mbed.h>


L298::L298(PinName pin1, PinName pin2, PinName pin3):m_motorEnable(pin1),m_motorBw(pin2),m_motorFw(pin3){
    /*class constructor : initializes the motors with 
    forward enable and speed of 0.3 */
    
    //m_dir = true;
    //m_speed = 0.2;
    
    m_motorEnable.period_ms(1);
    
    SetDirection(1);
    SetSpeed(0.2);
}
    
    
void L298::SetDirection(bool dir){
    /*set direction of one of the sides depending on pwmSelect
    direction : 1 go forward  ,0 go backwards*/    
    
    
    
    if(dir){
        m_motorBw = 0;
        m_motorFw = 1; 
    }
    else{
        m_motorBw = 1;
        m_motorFw = 0;
    }
        
    
    m_prevDir = dir;
        
}


void L298::SetSpeed(float speed){
    /*set speed on the pwm which is point by m_pwmPtr (set by SetDirection)
    speed : the speed given to the motor, ranges from 0 to 1*/
    
    if(speed<=0) m_motorEnable.write(0);
    else if(speed>=1.0)m_motorEnable.write(1.0);
    else m_motorEnable.write(speed);   
         
}


