#include <mbed.h>
#include "L298_H.h"
#include "IRSensor_H.h"

/*
Team Design Project 3 Group 1 : Create a Line Following Robot 

-----PINOUT-----

IR Sensor Pinout :
    - Left Sensor :         PTC6
    - Middle Left Sensor :  PTC5
    - Middle Sensor :       PTC4
    - Middle Right Sensor : PTC3
    - Right Sensor :        PTC0
    
Motor Left Control :
    - Motor Enable PWM :     PTA12
    - Backwards Dout :       PTA4
    - Forward Dout :         PTA5

Motor Right Control :
    - Motor Enable PWM :     PTA13
    - Backwards Dout :       PTD5
    - Forward Dout :         PTD0

-----ARCHITECTURE-----

RobotControl:
    Class which controls the speed and Direction of the Robot
    
IRSensor :
    Class which deals with sampling the IR sensors and with the PID Calculations
    The sampling happens every 10 ms thanks to the IRsampling Ticker
    
*/



Ticker IRsampling;
Timer t;
DigitalOut myled(LED_RED);

int main(){


bool toggleIR;

IRSensor IRSensor(PTC6, PTC5, PTC4, PTC3, PTC0, 0.27, 0.0, 0.0);

IRsampling.attach(callback(&IRSensor, &IRSensor::Sample), 0.01);

//initialise the class twice, one controls the left part and the other the right
L298 controlLeft(PTA12,PTA4,PTA5);
L298 controlRight(PTA13,PTD5,PTD0);

myled = 0;


 
 while(1){

    controlLeft.SetDirection(1);
    controlRight.SetDirection(1);
    
    controlLeft.SetSpeed(0.3);
    controlRight.SetSpeed(0.3);
    
    myled =1;
    
    wait(1);
    
    controlLeft.SetDirection(1);
    controlRight.SetDirection(0);
    
    controlLeft.SetSpeed(0.3);
    controlRight.SetSpeed(0.3);
    
    myled =0;
    
    wait(1);
    
    controlLeft.SetDirection(0);
    controlRight.SetDirection(1);
    
    controlLeft.SetSpeed(0.3);
    controlRight.SetSpeed(0.3);
    
    myled = 1;
    
    wait(1);
    
    controlLeft.SetDirection(0);
    controlRight.SetDirection(0);
    
    controlLeft.SetSpeed(0.3);
    controlRight.SetSpeed(0.3);
    
    myled = 0;
    
    wait(1);
    
    /*
    //waits for an interrupt to occur, then performs all the calculations
    if(toggleIR != IRSensor.m_toggle){
        
        t.start();
        IRSensor.WeightPID();
        IRSensor.CalculatePID();
        IRSensor.MotorControl();
        
        if(IRSensor.m_dirL != IRSensor.m_prevDirL) controlLeft.SetDirection(IRSensor.m_dirL);
        if(IRSensor.m_dirR != IRSensor.m_prevDirR) controlRight.SetDirection(IRSensor.m_dirR);
    
        controlLeft.SetSpeed(fabs(IRSensor.m_speedL));
        controlRight.SetSpeed(fabs(IRSensor.m_speedR));
    
        IRSensor.m_prevDirL = IRSensor.m_dirL;
        IRSensor.m_prevDirR = IRSensor.m_dirR;
        
        t.stop();
        //printf("timer : %f \n", t.read());
        t.reset();
        //printf("rightSpeed : %f, leftSpeed : %f \r", IRSensor.m_speedL, IRSensor.m_speedR);
        
        
        
        toggleIR = IRSensor.m_toggle;
        }*/
        
    
    }       
}