#include "RobotControl_H.h"
#include <mbed.h>


RobotControl::RobotControl(PinName pin1, PinName pin2, PinName pin3):m_motorEnable(pin1),m_motorBw(pin2),m_motorFw(pin3){
    /*class constructor : initializes the motors with 
    forward enable and speed of 0.3 */
    
    //m_dir = true;
    //m_speed = 0.2;
    
    m_motorBw.period_ms(1);
    m_motorFw.period_ms(1);
    
    SetDirection(1);
    SetSpeed(0.2);
}
    
    
void RobotControl::SetDirection(bool dir){
    /*set direction of one of the sides depending on pwmSelect
    direction : 1 go backwards  ,0 go forward*/    
    
    m_motorBw.write(0);
    m_motorFw.write(0);
    
    wait(0.001);
        
    if(!dir){
        m_motorEnable = false;
        m_pwmPtr = &m_motorFw;
    }else{
        m_motorEnable = true;
        m_pwmPtr = &m_motorBw;
    }
    
    m_prevDir = dir;
        
}


void RobotControl::SetSpeed(float speed){
    /*set speed on the pwm which is point by m_pwmPtr (set by SetDirection)
    speed : the speed given to the motor, ranges from 0 to 1*/
    
    if(speed<=0) m_pwmPtr->write(0);
    else if(speed>=1.0)m_pwmPtr->write(1.0);
    else m_pwmPtr->write(speed);   
         
}


