#ifndef IRSensor_H
#define IRSensor_H

#include <mbed.h>


//IRSensor deals with sampling and processing the data from the IR sensors
//the IR sensors are used to determine the position of the robot wrt the black line
//A PID controller system is used to stabilize the Robot above the black line

//Instantiation: the 5 pins for the IRSensor and Kp Ki and Kd for the PID

class IRSensor
{
private:
    
    DigitalIn m_leftIR;
    DigitalIn m_midLeftIR;
    DigitalIn m_midIR;
    DigitalIn m_midRightIR;
    DigitalIn m_rightIR;

    
    bool m_lineSensor[5];
    int m_error, m_prevError;
    
    float prevPID;
    
    float m_P, m_I, m_D;
    float m_PID;
    


public:
    
    bool m_dirL, m_dirR, m_toggle;
    float m_speedL, m_speedR;
    bool  m_prevDirL, m_prevDirR;
    float m_Kp, m_Ki, m_Kd, m_noErSpeed , m_turnSpeed;
    int m_color;
    
    
    IRSensor(PinName pin1, PinName pin2, PinName pin3, PinName pin4, PinName pin5, float Kp, float Ki, float Kd, float noErSpeed, float turnSpeed);
    
    //function attached to the ticker
    //reads the values from the Photodiodes to the linesensor array
    void Sample();
    
    //Assigns a weight to the error from the IRsensors result
    void WeightPID();
    
    //Calculates the total PID
    //the response will highly depend on Kp, Ki and Kd which can assigned when instantiating
    void CalculatePID();
    
    //controls the motor depending on the error calculated by the previous methods
    //takes in both RobotControls instances which control the left and right
    void MotorControl();
    
    
};



#endif