// ColourSensor_H.h

#ifndef ColourSensor_H
#define ColourSensor_H

#include "mbed.h"

// ColourSensor is used to detect the coloured disks and control the Solenoid
/* Attributes:
    - Pinouts of sensor inputs and solenoid output

   Methods:
    - solenoidSet
    - readColSenIf
    - readColSenWhich
    - colourCheck
    - makeColourActive
*/

class ColourSensor {
    public:
        void solenoidSet(bool state); // Setting solenoid state
        void solenoidOn(); // Interrupt to turn ON solenoid 
        void readSensor(); // Read sensors
        void convert(); // converts sensor readings to sensible logic
        void process(); // Colour processing
        void initialConditions(); // Sets initial conditions
        
        DigitalIn inOne;
        DigitalIn inTwo;
        DigitalOut solenoid;
        
        int firstLoop;
        bool toggleA;
        bool toggleB;
        bool toggleC;
        bool toggleConst; // Can be used to toggle colour processing
        
        bool newDetection; // Colour newly detected? (i.e. is now but wasn't before?) Yes/No -> 1/0
        bool flagColour;
        bool sensorOneCheck, sensorTwoCheck;
        ColourSensor(PinName pin1, PinName pin2, PinName pin3);
        
        void makeColourActive();
        void ColourCheck();
        bool diskColour; // Colour of disk: Red/Blue -> 1/0
        bool diskHave;
        bool sensorColour;
    private:
        bool sensorOne;
        bool sensorOneOld; // Comparison bool
        
        bool sensorTwo; 
         // Have disk? Yes/No -> 1/0
        bool sensorTwoOld;
        
        bool sensorIf; // Yes/No -> 1/0
        bool sensorIfOld;
         // Red/Blue -> 0/1
        
        
        bool solenoidState; // State of solenoid: On/Off -> 1/0
        
};

#endif