#include "mbed.h"
 //debug leds
PwmOut gled(p21);
DigitalOut myled(p20);
//Serial connection on p9 and p10
RawSerial ser(p9, p10); //TX, RX

char temp;
bool flag = false;
char gain, action;
float m_Kp = 0.0, m_Ki = 0.0, m_Kd = 0.0;
 
void ReadRpi(){
//attached to interrupt
//reads and store the char sent on Rx in temp
    
    if(ser.readable()) temp = ser.getc();
    flag =  1;
    myled = !myled;

}



void ReadSer(){
    //reads the information in temp 
    //if temp is either p,i or d, it assigns the value to gain
    //else if temp is + or -, it either increases or decreases the chosen parameter
    
    if(temp == 'p' || temp == 'i' || temp == 'd')gain = temp;
    switch(gain){
        case 'p':
            if(temp == '+' )m_Kp += 0.01;                    
            else if(temp == '-' && m_Kp >= 0) m_Kp -= 0.01;    
            break;
        case 'i':
            if(temp == '+') m_Ki += 0.01;
            else if(temp == '-' && m_Ki >= 0) m_Ki -= 0.01;    
            break;
        case 'd':
            if(temp == '+') m_Kd += 0.0001;    
            else if(temp == '-' && m_Kp >= 0) m_Kp -= 0.0001;    
            break;
        default:
            break;
        }
        
        gled.write(m_Kp);
    
    flag = 0;
    myled = !myled;
}
 
 
 
int main() {
    
    gain = 0;
    action = 0;
    myled= 1;
    gled.period(0.01);
    ser.format(8, SerialBase::None, 1);
    ser.baud(9600);
    ser.attach(&ReadRpi,Serial::RxIrq);
 
    while(1) {
        if(flag == 1){
            ReadSer();
            flag = 0;
        }     
    }
}