#include "mbed.h"
#include "TextLCD.h"

AnalogIn analog_value(A0);
Serial pc(USBTX, USBRX);

DigitalOut led(LED1);
TextLCD LCD(PA_0,PA_1,PA_4,PB_0,PC_1,PC_0);

int main()
{
    float meas_r;
    float meas_v;
    
    LCD.printf("HelloWorld");
    
    pc.printf("\n\rAnalogIn example\n\r");

    while(1) 
    {

        meas_r = analog_value.read(); // Read the analog input value (value from 0.0 to 1.0 = full ADC conversion range)
        meas_v = meas_r * 3300; // Converts value in the 0V-3.3V range
        
        // Display values
        pc.printf("measure = %f = %.0f mV\n\r", meas_r, meas_v);
        LCD.locate(0,1);
        LCD.printf("Tension = %f mV", meas_v);
        // LED is ON is the value is below 1V
        if (meas_v < 1000) 
        {
            led = 1; // LED ON
        } 
        else 
        {
            led = 0; // LED OFF
        }

        wait(1.0); // 1 second
    }
    
    return 0;
}
