#include "mbed.h"

DigitalOut IN1(D8);
DigitalOut IN2(D9);
PwmOut ENA(D3);

DigitalOut IN3(D6);
DigitalOut IN4(D7);
PwmOut ENB(D5);

void Init();
void Sortir();
void Entrer();
void Stop();

int main() 
{
    Init();
    
    Sortir();
    wait(2);
    Entrer();
    wait(2);
    
    ENB = 1;
    IN3 = 0;
    IN4 = 1;
}

void Init()
{
    wait_ms(500);
    IN1 = 0;
    IN2 = 0;
    IN3 = 0;
    IN4 = 0;
}

void Sortir()
{
    ENA = 0.2;
    IN1 = 1;
    IN2 = 0;
    wait(2.5);
    Stop();
}

void Entrer()
{
    ENA = 0.2;
    IN1 = 0;
    IN2 = 1;
    wait(1.7);
    Stop();
}

void Stop()
{
    IN1 = 0;
    IN2 = 0;
}