#include "mbed.h"
#include "BiQuad.h"
#include "HIDScope.h"
#include "MODSERIAL.h"
#include <math.h>

MODSERIAL   pc(USBTX, USBRX);
Ticker      sampleTicker;
Ticker      goTicker;
AnalogIn    emg0(A0);
AnalogIn    emg1(A1);
DigitalOut  ledG(LED_GREEN);
DigitalOut  ledB(LED_BLUE);
DigitalOut  ledR(LED_RED);
HIDScope    scope(2);

double no_b0 = 0.9911;
double no_b1 = -1.6036;
double no_b2 = 0.9911;
double no_a1 = -1.6036;
double no_a2 = 0.9822;

double hf_b0 = 0.9355;
double hf_b1 = -1.8711;
double hf_b2 = 0.9355;
double hf_a1 = -1.8669;
double hf_a2 = 0.8752;

double lf_b0 = 8.7656e-5;
double lf_b1 = 1.17531e-4;
double lf_b2 = 8.7656e-5;
double lf_a1 = -1.9733;
double lf_a2 = 0.9737;

double no_v1 = 0, no_v2 = 0;
double hf_v1 = 0, hf_v2 = 0;
double lf_v1 = 0, lf_v2 = 0;
double no_y;
double lf_y;
double hf_y;
double rect_y;
int go = 0;
const double threshold_value = 0.13;

double biquad_no(double u, double&v1 , double&v2 , const double a1 , const double a2 , const double b0 ,
    const double b1 , const double b2 )
{
    double v = u - a1*v1 - a2*v2;
    double y = b0*v + b1*v1 + b2*v2;
    v2 = v1;
    v1 = v;
    return y;
}

double biquad_hf(double u, double&v1 , double&v2 , const double a1 , const double a2 , const double b0 ,
    const double b1 , const double b2 )
{
    double v = u - a1*v1 - a2*v2;
    double y = b0*v + b1*v1 + b2*v2;
    v2 = v1;
    v1 = v;
    return y;
}

double biquad_lf(double u, double&v1 , double&v2 , const double a1 , const double a2 , const double b0 ,
    const double b1 , const double b2 )
{
    double v = u - a1*v1 - a2*v2;
    double y = b0*v + b1*v1 + b2*v2;
    v2 = v1;
    v1 = v;
    return y;
}

void scopeSend(void){
    no_y = biquad_no(emg0.read(), no_v1, no_v2, no_a1, no_a2, no_b0, no_b1, no_b2);
    hf_y = biquad_hf(no_y, hf_v1, hf_v2, hf_a1, hf_a2, hf_b0, hf_b1, hf_b2);
    rect_y = fabs(hf_y);
    lf_y = biquad_lf(rect_y, lf_v1, lf_v2, lf_a1, lf_a2, lf_b0, lf_b1, lf_b2)/0.2;  
    scope.set(0, emg0.read());
    scope.set(1, lf_y);
    scope.send();
    
    }
    
void threshold(double lf_y, const double threshold_value){
   if (lf_y > threshold_value){
   go = !go
   }
   /* if (lf_y > threshold_value){
        ledB = !ledB;
        }
    else{
        ledB = ledB;
            }
        }
*/

int main(){
   
  /**Attach the 'sample' function to the timer 'sample_timer'.
    * this ensures that 'sample' is executed every... 0.002 seconds = 500 Hz
    */
   // emgSampleTicker.attach(&sample, 0.002);
    // empty loop, sample() is executed periodically
    
    sampleTicker.attach(scopeSend,0.002);
    goTicker.attach(threshold,0.002);
    
    while(1) {
        if (go == 0){
            ledB = ledB;
            }
            else{
                ledB = !ledB;
    }
}