#include "mbed.h"
#include "BioRobotics_filtervalues.h"

// Define a Ticker, variables for storage, input (EMG signal) and output
DigitalOut myled(LED_GREEN)
Ticker biquadTicker;
AnalogIn emg( A0);

double v1=0, v2=0, u=0, y = 0;

//Implement the computation function
void computeBiquad(){
    double v=u-a1*v1-a2*v2;
    y=b0*v+b1*v1+b2*v2;
    v2=v1;
    v1=v;
}

void emgSample(){
    double emgFiltered = bqc.step(emg.read() );
}

int main(){
    bqc_hf.add(&bq_hf1).add(&bq_hf2).add(&bq_hf3);
    emgSampleTicker.attach(&emgSample,0.01);
    pc.baud(115200);
        while(1){
            e=emgFiltered;
            pc.printf("%e\r\n",e);
            wait(0.5f);
            myled=!myled; // toggle led
            }
}