#ifndef SSCM_COMM_H
#define SSCM_COMM_H
/*
 *  v 1.01 inital published , tested
 *  v 1.20 added devnr,  added range checking 
 *  v 1.30 added \0 to cmd field
 *  v 1.40 added status in cmd , added SSCM as device 
 *  v 2.00 corrected the type for data in data out
 *  v 3.00 added x, y , removed ch (replaced by x 
 *  v 3.01 corrected name SSCCM to SSCM 
 *  v 3.20 added version functions
 *  v 3.30 version functions moved to getVersion class 
 */

#define SSCM_COMM_LIB_HDR_VERSION "3.31"

#include "getVersion.h"


namespace sscm_comm    {
    //public :    
    
    enum ssc_dev{
        ADC=1,
        DAC=2,
        TEMP=3,
        SSCM=4
    };
    typedef  unsigned char u8;
    typedef  unsigned short u16;
    typedef struct {
            u8 module; // 1 char 0 --F
            u8 con;    // 1 char 0--2
            ssc_dev dev; // 2 char 01--03
            u8 devnr;
            char cmd[5]; // 4 char  + \0
            u8 ch; //  identify the channel or register address for the firmware      
            u8 x; //  char 00 -- 32   x coordinate MPPC   not used for the firmware ,so not coded in the string 
            u8 y;  // y coordinate MPPC not used for the communication to the SSCM y coordinate MPPC 
            u16 datain; // 2 char 0000 -- FFFF
            u16 dataout;// 2 char 00 -- FF
            u8 status;
    } ssc_cmd;
    
    const char  CMDSTART= '$';
    const char  CMDSTOP= '#';
    const char SEP=  ';';
    
    // decode the string sent to the uP to the original cmd structure , for the moment the input string is cleared 
    // param input :  input string at least char [30]
    // param ssc_cmd  the cmd structure to be filled 
    int decode_cmd(char * input, ssc_cmd * sc);
    
    // param output the string to be sent to the SSCM 
    // param sc the cmd to be sent to the SSCM 
    void encode_cmd(char * output, ssc_cmd *sc);
        
    // to get info of the module nr , connector serial number for a given plane 
    // param  plane  plane nr for which the cmd coordinates has to be known
    // param modulenr  the module nr  ( first nr in the cmd structure 
    // param connr  connector number ( 1 or 2) 
    // param serailnr  the serial nr of the board ( can be used for verification) .
    
    void getmodulecordinate(u8 plane, u8& modulenr, u8& connr, u8& serialnr);
    void get_mppc_dac_chnr(u8 plane, u8 x, u8 y, u8& ch, u8& modulenr, 
                           u8& connr, u8&dacch, u8& serialnr);
    void get_mppc_adc_chnr(u8 plane, u8 x, u8 y, u8& ch, u8& modulenr,
                           u8& connr, u8& adcdevnr, u8& adcchnr, u8& serialnr);
    // check if ranges are correct 
    // v 1.20  only check ADC devnr range broadcast not supported
    int check_ranges(ssc_cmd* sc);
    
    // returns the version and sub version nr.  
    // param hexversion  : 16 bits   MSB byt contains the version nr, LSB byte contains the subversion nr (hex) 
    // param version  : will  be set to the version 
    // param subversion : will be set to the subversion 
    void get_dec_version(u16 hexversion, u8& version, u8& subversion);
    
    // reuse vesion class
    
    class getsscmVersion: public  getVersion { 
        public:
            getsscmVersion();
    };

};
#endif
