#if   defined (TARGET_KL25Z) 
// in mbed problems to call  strtol
#include "mbed.h" // for the strtol 
#else 
#include <stlib.h>  // for the strtol 
#endif

#include "sscm_comm.h"


#define SSCM_COMM_LIB_SRC_VERSION "3.31"

using namespace sscm_comm;

int  sscm_comm::decode_cmd(char* input, ssc_cmd * sc){
    char part[6];
    int rv = 0;
    part[0] = input[0];
    part[1] = input[1];
    part[2] = 0;
    sc->module = (u8) strtol(part, NULL, 16);
    if(input[3] != SEP) {
        rv =-1;  // tbd check for module range
    } else { 
        u16 ic;//input counter
        part[0] = input[4];
        part[1] = input[5];
        part[2] = 0;
        sc->con = (u8) strtol(part, NULL, 16);
        if(input[6] != SEP) {
            rv = -2;  // tbd check for connector range 
        } else {
            part[0] = input[7];
            part[1] = input[8];
            part[2] = 0;
            sc->dev = (ssc_dev) strtol(part, NULL, 16);
            if (input[9] != SEP) {
                rv = -3;
            } else {
                ic = 10;
                part[0] = input[ic++];
                part[1] = input[ic++];
                part[2] = 0;
                sc->devnr = (u8) strtol(part, NULL, 16);
                if (input[ic++] != SEP) {
                    rv = -9;
                } else {
                    sc->cmd[0] = input[ic++];
                    sc->cmd[1] = input[ic++];
                    sc->cmd[2] = input[ic++];
                    sc->cmd[3] = input[ic++];
                    sc->cmd[4] = '\0';
                    if (input[ic++] != SEP) {
                        rv = -4;   
                    } else {      
                        part[0] = input[ic++];
                        part[1] = input[ic++];
                        part[2] = 0;
                        sc->ch = (u8) strtol(part, NULL, 16);
                        if (input[ic++] != SEP) {
                            rv= -5;
                        } else {
                            part[0] = input[ic++];
                            part[1] = input[ic++];
                            part[2] = input[ic++];
                            part[3] = input[ic++];
                            part[4] = 0;
                            sc->datain = (u16) strtol(part, NULL, 16);
                            if(input[ic++] != SEP)  {
                                rv= -6;
                            } else {
                                part[0] = input[ic++];
                                part[1] = input[ic++];
                                part[2] = input[ic++];
                                part[3] = input[ic++];
                                part[4] = 0;
                                sc->dataout = (u16) strtol(part, NULL, 16);
                                if (input[ic++] != SEP) {
                                    rv= -7;
                                } else {
                                    part[0] = input[ic++];
                                    part[1] = input[ic++];
                                    part[4] = 0;
                                    sc->status = (u8) strtol(part, NULL, 16);
                                    if (input[ic++] != SEP) {
                                        rv = -8;
                                    } else {
                                        rv = 0;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    int crr = check_ranges(sc);
    if (crr < 0) rv = crr;
    for (int i = 0; i < 27; i++) {
        input[i] = 0;
    }
    return rv;
}

int sscm_comm::check_ranges(ssc_cmd * sc) {
    int rv = 1;  // no check done 
    // devnr check 
    if (sc->con < 1 || sc->con > 2) {
        rv = -43;
        goto RVOUT; // goto jail. Do not collect £200.
    } 
    switch (sc->dev) {
         case  ADC:
            if (sc->devnr < 1 || sc->devnr > 2) {
                rv = -23;
                break;
            }
            break;
         case TEMP:
            if (sc->ch < 1 || sc->ch > 2) {
                rv = -22;
                break;
            }
            break;
         default:
            rv = 1;
    }
RVOUT:
    return rv; 
}     

void sscm_comm::encode_cmd(char * output, ssc_cmd * sc) {
    sprintf(output,
            "%c%02X%c%02X%c%02X%c%02X%c%c%c%c%c%c%02X%c%04X%c%04X%c%02X%c%c\0",
            CMDSTART, sc->module, SEP, sc->con, SEP, sc->dev, SEP, sc->devnr, 
            SEP, sc->cmd[0], sc->cmd[1], sc->cmd[2], sc->cmd[3],
            SEP, sc->ch, SEP, sc->datain, SEP, sc->dataout, SEP,
            sc->status, SEP, CMDSTOP);
}
    
void sscm_comm::getmodulecordinate(u8 plane, u8& modulenr, u8& connr, u8& serialnr) {
    // to be implemented  
    modulenr=0;
}    

/*
u16 sscm_comm::getSrcVersion(){
    return get_hex_version_nr(SSCM_COMM_LIB_SRC_VERSION);   
}

u16 sscm_comm::getHdrVersion(){
    return get_hex_version_nr(SSCM_COMM_LIB_HDR_VERSION );   
}    
*/ 

void sscm_comm::get_mppc_dac_chnr(u8 plane, u8 x, u8 y, u8& ch, u8& modulenr,
                                  u8& connr, u8& dacch, u8& serialnr) {
}

void sscm_comm::get_mppc_adc_chnr(u8 plane, u8 x , u8 y, u8& ch, u8& modulenr,
                                  u8& connr, u8& adcdevnr, u8& adcchnr,
                                  u8& serialnr) {
}

sscm_comm::getsscmVersion::getsscmVersion(): 
    getVersion(SSCM_COMM_LIB_HDR_VERSION, SSCM_COMM_LIB_SRC_VERSION, __TIME__, __DATE__){
}
