#include "mbed.h"
/* SOLID SM1 Slow Control firmware 
 *
 
  * V 1.0?  initial version   release 
  * v 1.11  version , added status field 
  * v 1.13  corrected error in ADC register write
  * v 1.14  added heartbeat off / in
  * v 1.20  added DAC
  * v 1.30  added Temperature probe support   
  * v 1.31  bug correction ,for selecting the probe the devnr has to be used 
  * v 1.35  added version read for software modules  (comm, T , ADC , DAC  SWSPI) 
  * v 1.36  added ini1 ini2  srst commands for DAC 
  * v 1.37  new get Version class
*/ 

#define VERSION "1.37"


#include "SWSPI_BI.h"
#include "solid_sctrl_def.h"
#include "S_SCTRL_SM1_PinDef.h" 
#include "S_SCTRL_SM1_hwfunct.h" 
#include "AD9249.h"
#include "AD5384.h"
#include "adt7320.h"
#include "getVersion.h"

#define DEBUGPF(x) printf((x));


#define MAXCMDLLENGTH 256

#include "sscm_comm.h"
using namespace sscm_comm ;

Serial pc(USBTX,USBRX);

char cmdin[MAXCMDLLENGTH];
u8 cmdready;
bool cmdstart=false;

void pc_callback() {
    // Note: you need to actually read from the serial to clear the RX interrupt  
    static unsigned char cnt;
    char c;
    c = pc.getc();
    if (c == CMDSTART && !cmdready) {
        cnt = 0;
        cmdstart = true;
        cmdready = false;
    }
    if (cmdstart) { 
        cmdin[cnt] = c;
        cnt++;             
        if (c == CMDSTOP) {
            cmdready = true;
        } 
    }           
    //printf("%c:",c );    
 }

int main() {
    pc.attach(pc_callback);
    ssc_cmd cmd;
    bool heartbeat = true;
    int i = 0;
    HWlines hwl;
    assignports(&hwl);
    setdefault(hwl);
    // reuse getVesion 
    getVersion gv(VERSION, VERSION, __TIME__, __DATE__);
    getVersion gvc;
    getsscmVersion gvsscm;
    SWSPI spi(hwl.mosi[0], hwl.miso[0], hwl.sclk[0]); // mosi, miso, sclk
    SWSPI spi2(hwl.mosi[1], hwl.miso[1], hwl.sclk[1]); // mosi, miso, sclk
  
    SWSPI_BI spi_adc(hwl.msio[0], hwl.direction[0], hwl.stio_mo[0], 
                     hwl.sclk[0]); // msio, dir , sclk 
    SWSPI_BI spi_adc2(hwl.msio[1], hwl.direction[1], hwl.stio_mo[1],
                      hwl.sclk[1]); // msio, dir , sclk 
    // initalize ADC classes 
    AD9249 adc[2][2] = {AD9249(&spi_adc, hwl.csb1[0]),
                        AD9249(&spi_adc, hwl.csb2[0]),
                        AD9249(&spi_adc2, hwl.csb1[1]),
                        AD9249(&spi_adc2, hwl.csb2[1])};
    AD5384 dac[2][1] = {AD5384(&spi, hwl.dac_cs[0]),
                        AD5384(&spi2, hwl.dac_cs[1])};
      
    adt7320 temp[2][3] = {adt7320(&spi, hwl.t_cs[0]),
                          adt7320(&spi, hwl.tc_cs1[0]),
                          adt7320(&spi, hwl.tc_cs2[0]),
                          adt7320(&spi2, hwl.t_cs[1]),
                          adt7320(&spi2, hwl.tc_cs1[1]),
                          adt7320(&spi2, hwl.tc_cs2[1])};
                          
    pc.printf("\nSOLID SLOW CONTROL for SM1 version %s %s %s  \n\r", VERSION,
              __DATE__, __TIME__);
    cmdready = false;
    while (1) {
        wait(0.5);
        char cmdoutstr[100];  
        if (cmdready) {
            cmdready = false;
            int decresult = decode_cmd(cmdin, &cmd);
            printf("decode result = %d \n\r", decresult);
            if (decresult) {
                cmd.status = abs(decresult); 
                encode_cmd(cmdoutstr, &cmd);
                continue;
            }           
            u8 do8; // dataout
            u16 do16;
            cmd.status = 1; // use it for the moment as error handling , 
            switch (cmd.dev) {
                case ADC:   
                    cmd.status = 2;
                    pc.printf("ADC cmd = %s \n\r", cmd.cmd);
                    pc.printf("check now ranges %d %d  \n\r", cmd.con,
                              cmd.devnr);
                    if (!strcmp(cmd.cmd, "spa1")) {
                        adc[cmd.con - 1][cmd.devnr - 1].setPattern1(cmd.datain);
                        cmd.dataout = cmd.datain;
                        cmd.status = 0;
                    }
                    if (!strcmp(cmd.cmd, "spa2")) {
                        adc[cmd.con - 1][cmd.devnr - 1].setPattern2(cmd.datain);
                        cmd.dataout = cmd.datain;
                        cmd.status = 0;
                    }
                    if (!strcmp(cmd.cmd, "rpa1")) {
                        adc[cmd.con - 1][cmd.devnr - 1].readPattern1(do16);
                        cmd.dataout=do16;
                        cmd.status=0;
                    }
                    if (!strcmp(cmd.cmd, "rpa2")) {
                        adc[cmd.con - 1][cmd.devnr - 1].readPattern2(do16);
                        cmd.dataout=do16;
                        cmd.status=0;
                    }
                    if (!strcmp(cmd.cmd, "rr08")) {
                        adc[cmd.con - 1][cmd.devnr - 1].readReg8(cmd.ch, do8);
                        cmd.dataout = (u16) do8;
                        cmd.status= 0 ;
                    }
                    if (!strcmp(cmd.cmd, "rr16")) {
                        adc[cmd.con - 1][cmd.devnr - 1].readReg16(cmd.ch, do16);
                        cmd.dataout = (u32) do16;
                        cmd.status = 0;
                    }
                    if (!strcmp(cmd.cmd, "sr08")) {
                        adc[cmd.con - 1][cmd.devnr - 1].setReg8(cmd.ch, (u8) cmd.datain);
                        cmd.dataout = cmd.datain;
                        cmd.status = 0;
                    }
                    if (!strcmp(cmd.cmd, "sr16")) {
                        adc[cmd.con - 1][cmd.devnr - 1].setReg16(cmd.ch, (u16) cmd.datain);
                        cmd.dataout = cmd.datain;
                        cmd.status = 0;
                    }
                    if (!strcmp(cmd.cmd, "ghrv")) {
                        do16 = adc[cmd.con - 1][cmd.devnr - 1].getHdrVersion();
                        cmd.dataout = do16;
                        cmd.status=0;
                    }
                    if (!strcmp(cmd.cmd, "gscv")) {
                        do16 = adc[cmd.con - 1][cmd.devnr - 1].getSrcVersion();
                        cmd.dataout = do16;
                        cmd.status = 0;
                    }
                    if (!strcmp(cmd.cmd, "ini1")) {
                        adc[cmd.con - 1][cmd.devnr - 1].init1();
                        cmd.dataout = cmd.datain;
                        cmd.status = 0;
                    }
                    if (!strcmp(cmd.cmd, "ini2")) {
                        adc[cmd.con - 1][cmd.devnr - 1].init2();
                        cmd.dataout = cmd.datain;
                        cmd.status = 0;
                    }
                    break;
                case DAC :
                    cmd.status = 2;
                    if (!strcmp(cmd.cmd, "sdac")) {
                        dac[cmd.con - 1][cmd.devnr - 1].set_dac(cmd.ch, cmd.datain);
                        cmd.dataout = cmd.datain;
                        cmd.status = 0;
                    }
                    if (!strcmp(cmd.cmd, "rdac")) {
                        do16=dac[cmd.con - 1][cmd.devnr - 1].get_dac(cmd.ch);
                        cmd.dataout = do16;
                        cmd.status = 0;
                    }
                    if (!strcmp(cmd.cmd, "ini1")) {
                        dac[cmd.con - 1][cmd.devnr - 1].init1();
                        cmd.dataout = cmd.datain;
                        cmd.status = 0;
                    }
                    if (!strcmp(cmd.cmd, "ini2")) {
                        dac[cmd.con - 1][cmd.devnr - 1].init2();
                        cmd.dataout = cmd.datain;
                        cmd.status = 0;
                    }
                    if (!strcmp(cmd.cmd, "srst")) {
                        dac[cmd.con - 1][cmd.devnr - 1].soft_rst();
                        cmd.dataout = cmd.datain;
                        cmd.status = 0;
                    }
                    if (!strcmp(cmd.cmd, "ghrv")) {
                        do16 = dac[cmd.con - 1][cmd.devnr - 1].getHdrVersion();
                        cmd.dataout = do16;
                        cmd.status = 0;
                    }
                    if (!strcmp(cmd.cmd, "gscv")) {
                        do16 = dac[cmd.con - 1][cmd.devnr - 1].getSrcVersion();
                        cmd.dataout = do16;
                        cmd.status = 0;
                    }
                    break; 
                case TEMP:
                    cmd.status = 2;
                    if (!strcmp(cmd.cmd, "rtpd")) {
                        do16 = temp[cmd.con - 1][cmd.devnr - 1].get_T();
                        cmd.dataout = do16;
                        cmd.status = 0;
                    }
                    if (!strcmp(cmd.cmd, "gtid")) {
                        do8 = temp[cmd.con - 1][cmd.devnr - 1].getId();
                        cmd.dataout = do8;
                        cmd.status = 0;
                    }
                    if (!strcmp(cmd.cmd, "rtcr")) {
                        do16 = temp[cmd.con - 1][cmd.devnr - 1].get_TcritSP();
                        cmd.dataout = do16;
                        cmd.status = 0;
                    }
                    if (!strcmp(cmd.cmd, "stcr")) {
                        temp[cmd.con - 1][cmd.devnr - 1].set_TcritSP(cmd.datain);
                        cmd.dataout = cmd.datain;
                        cmd.status = 0;
                    }
                    if (!strcmp(cmd.cmd, "ghrv")) {
                        do16 = temp[cmd.con - 1][cmd.devnr - 1].getHdrVersion();
                        cmd.dataout = do16;
                        cmd.status = 0;
                    }
                    if (!strcmp(cmd.cmd, "gscv")) {
                        do16 = temp[cmd.con - 1][cmd.devnr - 1].getSrcVersion();
                        cmd.dataout = do16;
                        cmd.status = 0;
                    }
                    if (!strcmp(cmd.cmd, "ini1")) {
                        temp[cmd.con - 1][cmd.devnr - 1].init1();
                        cmd.dataout = cmd.datain;
                        cmd.status = 0;
                    }
                    if (!strcmp(cmd.cmd, "ini2")) {
                        temp[cmd.con - 1][cmd.devnr - 1].init2();
                        cmd.dataout = cmd.datain;
                        cmd.status = 0;
                    }
                    break;
                case SSCM: 
                    cmd.status = 2;
                    if (!strcmp(cmd.cmd, "t_hb")) {
                        heartbeat = !heartbeat;
                        cmd.status = 2;
                    }
                    if (!strcmp(cmd.cmd, "gmpv")) {
                        do16 = gv.getHdrVersion();
                        cmd.dataout = do16;
                        cmd.status = 0;
                    }        
                    if (!strcmp(cmd.cmd, "gvhv")) {
                        do16 = gvc.getHdrVersion();
                        cmd.dataout = do16;
                        cmd.status = 0;
                    }
                    if (!strcmp(cmd.cmd, "msnr")) {
                        do8 = get_serialnr(&hwl);
                        cmd.dataout = (u16) do8;
                        cmd.status = 0;
                    }
                    if (!strcmp(cmd.cmd, "gchv")) {
                        do16 = gvsscm.getHdrVersion();
                        cmd.dataout = do16;
                        cmd.status = 0;
                    }
                    if (!strcmp(cmd.cmd, "gcsv")) {
                        do16 = gvsscm.getSrcVersion();
                        cmd.dataout = do16;
                        cmd.status = 0;
                    }          
                    break;
             default:
                cmd.status = 1;
             break;
            } // end switch 
            encode_cmd(cmdoutstr, &cmd);  
            pc.printf("%s", cmdoutstr);
        } else {//end  if cmdready 
             if (heartbeat) printf("%03d>%s\n\r", (i++ % 1000), cmdin);
        }
    }// end while 
}
